var wscmd;
var wsnotify;
var toDownload = true; //if need show download dialog, should be excuted only once
var wsInitConnected;
var is_exist_MP=false;
var wsInitCheckTimer;

function WebsocketConnectError() {

    if(!is_exist_MP) {
                $('#msg').text(_AN_str_h5_msg_install);
                $('.spinner').addClass('hide');
                $.get('./vpn_download.html')
                    .done(function (doc) {
                        $('#vpnBox').html(doc).modal('show');
                });
            }
}
var cs = {
    init: function () {
        this.render();
        this.mobileDetece();
        this.bindEvent();
    },

    mobileDetece: function () {
        var ua = detect.parse(navigator.userAgent);
        var os = ua.os.family;
        if (os.indexOf('Android') > -1 || os.indexOf('iOS') > -1) {
            this.handleMobile();
            return true;
        } else {
            this.ipcinit();
            return false;
        }
    },

    handleMobile: function () {
        $('#msg').text(_AN_str_h5_cs_notsupport);
        $('.spinner').addClass('hide');
    },

    bindEvent: function () {

    },

    render: function () {
        $('#msg').text(_AN_str_launch_CliSec);
        $('#title').text(_AN_str_h5_cs);
        $('title').text(_AN_str_h5_cs);
    },

    ipcinit: function () {
        console.log("ipcinit");
        wsInitConnected = 0;
        wscmd = new WebSocket("wss://127.0.0.1:60012/ws/command");
        wsnotify = new WebSocket("wss://127.0.0.1:60012/ws/notify");

        wsInitCheckTimer = setTimeout(this.checkWebSocketStatus, 3000);

        wscmd.onopen = function (event) {
            console.log("websocket command onopen");

            wsInitConnected += 1;
            if (wsInitConnected == 2) {
                clearTimeout(wsInitCheckTimer);
                cs.getClientSecurityResult();
            }
        };

        wscmd.onmessage = function (event) {
            console.log("websocket command onmessage: " + event.data);
            cs.showCommandResponseMessage(event.data);
        };

        wscmd.onclose = function (event) {
            console.log("websocket command onclose: " + event.data);
            wsInitConnected = 0;
            console.log("close ws");

            console.log("timer for update init");
            setTimeout("update_wsinit();",5000);
        };

        wscmd.onerror = function (event) {
            console.log("websocket command onerror: " + event.data);
            clearTimeout(wsInitCheckTimer);
            wsInitConnected = 0;
            WebsocketConnectError();
        };

        wsnotify.onopen = function (event) {
            console.log("websocket notify onopen");
            is_exist_MP = true;
            wsInitConnected += 1;
            if (wsInitConnected == 2) {
                clearTimeout(wsInitCheckTimer);
                cs.getClientSecurityResult();
            }
        };

        wsnotify.onmessage = function (event) {
            console.log("\n-----------------------------------------\n");
            console.log("websocket notify onmessage: " + event.data);
            cs.showCallbackMessage(event.data);
        };

        wsnotify.onclose = function (event) {
            console.log("websocket notify onclose: " + event.data);
            wsInitConnected = 0;
        };

        wsnotify.onerror = function (event) {
            console.log("websocket notify onerror: " + event.data);
            wsInitConnected = 0;
        };
    },

    checkWebSocketStatus: function () {
        var ok = true;
        if (wscmd.readyState != WebSocket.OPEN) {
            console.log("websocket command is not ready!");
            ok = false;
        }
        if (wsnotify.readyState != WebSocket.OPEN) {
            console.log("websocket notify is not ready!");
            ok = false;
        }

        if (!ok) {
            wscmd.close();
            wsnotify.close();
            WebsocketConnectError();
        }
    },

    mapErrorCodeMac: function (arr) {
        var msg = {};
        msg['1111'] = _AN_str_h5_cs_info_1004+'</br></br>';
        msg['1000'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1005+"<br/>";
        msg['1001'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1006+"<br/>";
        msg['1002'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1007+"<br/>";
        msg['1003'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1008+"<br/>";
        msg['1004'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1009+"<br/>";
        msg['1005'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1010+"<br/>";
        msg['1006'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1011+"<br/>";
        msg['1007'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1012+"<br/>";
        msg['1008'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1013+"<br/>";
        msg['1009'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1014+"<br/>";
        var info = '';

        for (x in arr) {
            info += msg[arr[x]];
        }
        console.log(info);
        $('#msg').html(info);
        $('.spinner').addClass('hide');
    },

    showCommandResponseMessage: function (data) {
        if (data == null) {
            console.log("response message is empty!");
            return;
        }

        var msg = JSON.parse(data)
        if (typeof msg != "object") {
            console.log("response message is not a object!");
            return;
        }

        if (msg.action == 13) {
            console.log("hardwardid: " + msg.data.response);
            return;
        }

        if (msg.action == 15) { // handle response
            var mac_os = this.isMac();
            if(!mac_os) {
                this.parseClientSecurity(msg.data.response);
            } else {
                var res = msg.data.response.split('###');
                var errorCode = [];
                var successUrl = '';
                if (res[0] == 'FAIL') {
                    console.log('FAIL');
                    if(res[1].indexOf('1004') == 0) {
                        errorCode.push('1111');
                        var err = res[1].substring(4).split('&');
                        for (x in err) {
				if(typeof(err[x])!='undefined' && err[x] != '') {
                                	errorCode.push('100'+err[x]);
				}
                        }
                    }
                    this.mapErrorCodeMac(errorCode);
                    console.log(errorCode);
                } else {
                    console.log('Success');
                    successUrl = res[1];
                    this.handleSuccessUrl(successUrl);
                }
            }
            return;
        }
    },

    showCallbackMessage: function(data) {
    },

    getClientSecurityResult: function () {
        if (wsInitConnected == 0) {
            location.reload();
        }
        console.log("Get client-security");

        var port = 443;
        if (window.location.port.length > 0) {
            port = parseInt(window.location.port);
        }
        var host = window.location.hostname;

        var msg = {
            error: 0,
            message: "check client security from javascript",
            action: 15,
            data: {
                    action: 15,
                    host: host,
                    port: port
            }
        };

        wscmd.send(JSON.stringify(msg));
    },

    isMac: function () {
        var ua = detect.parse(navigator.userAgent);
        var os = ua.os.family;
        if (os.indexOf('Mac') > -1) {
            console.log('is MacOS');
            return true;
        } else {
            console.log('not MacOS');
            return false;
        }
    },

    parseClientSecurity: function (str) {
        str = atob(str);
        var res = str.split('###');
        var errorCode = [];
        var successUrl = '';
            if (res[1] == 'FAIL') {
                console.log('FAIL');
                var error = res[2].split('***');
                
                for (var i = 1; i < error.length; i += 2) {
                    errorCode.push(error[i]);
                }
                this.mapErrorCode(errorCode);
                console.log(errorCode);
            } else {
                console.log('Success');
                successUrl = res[2];
                this.handleSuccessUrl(successUrl);
            }
        },

        mapErrorCode: function (arr) {
            var msg = {};
            msg['1004'] = _AN_str_h5_cs_info_1004+'</br></br>';
            msg['1005'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1005+"<br/>";
            msg['1006'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1006+"<br/>";
            msg['1007'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1007+"<br/>";
            msg['1008'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1008+"<br/>";
            msg['1009'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1009+"<br/>";
            msg['1010'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1010+"<br/>";
            msg['1011'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1011+"<br/>";
            msg['1012'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1012+"<br/>";
            msg['1013'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1013+"<br/>";
            msg['1014'] = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+_AN_str_h5_cs_info_1014+"<br/>";
            
            var info = '';

            for (x in arr) {
                info += msg[arr[x]];
            }
            console.log(info);
            $('#msg').html(info);
            $('.spinner').addClass('hide');
        },

        handleSuccessUrl: function (url) {
            if(typeof(url)!='undefined'&&url.length>5){
                var data = url.split('?')[1].substr(5);
                this.setCookie('NSCOOKIE%3Blocalhost%3B%2F%3BAN_CLIENTSEC', data);
            }
        },

        setCookie: function (name, value) {
            document.cookie = name + '=' + escape(value) + ';path=/';
            location.href = '/prx/000/http/localhost/login';
        }


    }

function update_wsinit(){
    if(is_exist_MP) {
        console.log('start ws init for updating');
        cs.init();
    }
};

$(function () {
    cs.init();
});
$(window).on('unload',
    function() {
        try {
            wsnotify.close();
            wscmd.close();
            console.log("websocket closed.");
        } catch(e) {
            console.log(e);
        }
    });