var wscmd, wsnotify;
//var _AN_motionpro_detect_prelogin = true;
var MotionPro = {
  port_list: [60012, 60014],//, 60016],
  MP_exist: false, // 是否存在 MP 客户端
  once: true,


  init: function () {
    this.websocketInit(60012);
  },

  websocketInit: function (port) {
    var wsInitConnected,
      wsInitCheckTimer,
      cmdUrl,
      notifyUrl,
      newVersion = false;

    console.log('detect MotionPro...');
    wsInitConnected = 0;

    cmdUrl = 'wss://127.0.0.1:' + port + '/ws/command';
    notifyUrl = 'wss://127.0.0.1:' + port + '/ws/notify'
    wscmd = new WebSocket(cmdUrl);
    wsnotify = new WebSocket(notifyUrl);

    wsInitCheckTimer = setTimeout(checkWebSocketStatus, 5000);

    wscmd.onopen = function (event) {
      console.log("websocket command onopen");

      wsInitConnected += 1;
      if (wsInitConnected == 2) {
        clearTimeout(wsInitCheckTimer);
        if (typeof(checkMP) != 'undefined') {
            clearTimeout(checkMP);
        }
        MotionPro.MP_exist = true;
        wscmd.close();
        wsnotify.close();
        if (typeof(_AN_motionpro_detect_prelogin)!='undefined'&&_AN_motionpro_detect_prelogin) {
              window.location.href = "./index.html";
        } else {
              window.location.href = "../welcome/index.html";
        }
      }
    };

    wscmd.onmessage = function (event) {
      console.log("websocket command onmessage: " + event.data);
    };

    wscmd.onclose = function (event) {
      console.log("websocket command onclose: " + event.data);
      wsInitConnected = 0;
    };

    wscmd.onerror = function (event) {
      console.log("websocket command onerror: " + event.data);
      clearTimeout(wsInitCheckTimer);
      wsInitConnected = 0;
      onWebsocketConnectError();
    };

    wsnotify.onopen = function (event) {
      console.log("websocket notify onopen");
      wsInitConnected += 1;
      if (wsInitConnected == 2) {
        clearTimeout(wsInitCheckTimer);
        if (typeof(checkMP) != 'undefined') {
            clearTimeout(checkMP);
        }
        MotionPro.MP_exist = true;
        wscmd.close();
        wsnotify.close();
        if (typeof(_AN_motionpro_detect_prelogin)!='undefined'&&_AN_motionpro_detect_prelogin) {
              window.location.href = "./index.html";
        } else {
              window.location.href = "../welcome/index.html";
        }
     }
    };

    wsnotify.onmessage = function (event) {
      console.log("\n-----------------------------------------\n");
      console.log("websocket notify onmessage: " + event.data);
    };

    wsnotify.onclose = function (event) {
      console.log("websocket notify onclose: " + event.data);
      wsInitConnected = 0;
    };

    wsnotify.onerror = function (event) {
      console.log("websocket notify onerror: " + event.data);
      wsInitConnected = 0;
    };

    function onWebsocketConnectError() {
      //if (MotionPro.port_list.indexOf(port) > -1 && port !== 60014) {
        //port += 2;
        //MotionPro.websocketInit(port);
      //} else {
        console.log("WebSocket connect error!");
        checkMP = setTimeout('MotionPro.websocketInit(60012)', 3000);
      //}
    }

    function checkWebSocketStatus() {
      var ok = true;
      if (wscmd.readyState != WebSocket.OPEN) {
        console.log("websocket command is not ready!");
        ok = false;
      }
      if (wsnotify.readyState != WebSocket.OPEN) {
        console.log("websocket notify is not ready!");
        ok = false;
      }
      if (ok) {
        wscmd.close();
        wsnotify.close();
        if (typeof(_AN_motionpro_detect_prelogin)!='undefined'&&_AN_motionpro_detect_prelogin) {
              window.location.href = "./index.html";
        } else {
              window.location.href = "../welcome/index.html";
        }
      } else {
        wscmd.close();
        wsnotify.close();
        onWebsocketConnectError();

      }
    }

  },

  mobileDetecte: function (str) {
    var ua = detect.parse(navigator.userAgent); // 引入 detect.js
    var os = ua.os.family;
    if (os.indexOf('Android') > -1 || os.indexOf('iOS') > -1) { // mobile
      return false;
    } else {
      return true;
    }
  },
};

if (MotionPro.mobileDetecte()) {
    MotionPro.init();
}

$(window).on('unload', function () {
    try {
      clearTimeout(wsInitCheckTimer);
      if (typeof(checkMP) != 'undefined') {
            clearTimeout(checkMP);
      }
      wsnotify.close();
      wscmd.close();
      console.log("websocket closed.");
    } catch (e) {
      console.log(e);
    }
  }) 
