var wscmd, wsnotify;
var toDownload = true; //if need show download dialog, should be excuted only once
var MotionPro = {
    port_list: [60012, 60014],
    MP_exist: false,
    init: function() {
        this.websocketInit(60012);
    },

    websocketInit: function(port) {
        var wsInitConnected, wsInitCheckTimer, cmdUrl, notifyUrl, newVersion = false;

        console.log('detect MotionPro...');
        wsInitConnected = 0;

        cmdUrl = 'wss://127.0.0.1:' + port + '/ws/command';
        notifyUrl = 'wss://127.0.0.1:' + port + '/ws/notify';
        wscmd = new WebSocket(cmdUrl);
        wsnotify = new WebSocket(notifyUrl);

        wsInitCheckTimer = setTimeout(checkWebSocketStatus, 3000);

        wscmd.onopen = function(event) {
            console.log("websocket command onopen");

            wsInitConnected += 1;
            if (wsInitConnected == 2) {
                clearTimeout(wsInitCheckTimer);
                MotionPro.MP_exist = true;
                $('#login').removeAttr('disabled');
                statusInit();
            }
        };

        wscmd.onclose = function(event) {
            console.log("websocket command onclose: " + event.data);
            wsInitConnected = 0;
        };

        wscmd.onerror = function(event) {
            console.log("websocket command onerror: " + event.data);
            clearTimeout(wsInitCheckTimer);
            wsInitConnected = 0;
            onWebsocketConnectError();
        };

        wsnotify.onopen = function(event) {
            console.log("websocket notify onopen");
            wsInitConnected += 1;
            if (wsInitConnected == 2) {
                clearTimeout(wsInitCheckTimer);
                MotionPro.MP_exist = true;
                $('#login').removeAttr('disabled');
                statusInit();
            }
        };

        wsnotify.onclose = function(event) {
            console.log("websocket notify onclose: " + event.data);
            wsInitConnected = 0;
        };

        wsnotify.onerror = function(event) {
            console.log("websocket notify onerror: " + event.data);
            wsInitConnected = 0;
        };

        wscmd.onmessage = function(event) {
            console.log("websocket command onmessage: " + event.data);
            showCommandResponseMessage(event.data);
        };

        function getStatus() {
            console.log("getStatus");
            if (wsInitConnected == 0) {
                console.log("getStatus, but wsInitConnected == 0");
                location.reload();
            }

            var msg = {
                error: 0,
                message: "get vpn status from javascript",
                action: 8,
                data: {
                    action: 8
                }
            };

            wscmd.send(JSON.stringify(msg));
        }
        function onWebsocketConnectError() {
            console.log("websocket connect error!");
            if (MotionPro.port_list.indexOf(port) > -1 && port !== 60014) {
                port += 2;
                MotionPro.websocketInit(port);
            } else {
                if (typeof(_AN_motionpro_detect_prelogin) != 'undefined' && _AN_motionpro_detect_prelogin) {
                    if (toDownload) {
                        downLoadMP();
                        toDownload = false;
                    }
                }
            }
        }

        function downLoadMP() {
            console.log('Dont detect MP client');
            window.location.href = "./download.html";
        }

        function checkWebSocketStatus() {
            var ok = true;
            if (wscmd.readyState != WebSocket.OPEN) {
                console.log("websocket command is not ready!");
                ok = false;
            }
            if (wsnotify.readyState != WebSocket.OPEN) {
                console.log("websocket notify is not ready!");
                ok = false;
            }

            if (!ok) {
                wscmd.close();
                wsnotify.close();
                onWebsocketConnectError();
            }
        }
        function statusInit() {
            getStatus();
        }
        function showCommandResponseMessage(data) {
            if (data == null) {
                console.log("response message is empty!");
                return;
            }

            var msg = JSON.parse(data);
            if (typeof msg != "object") {
                console.log("response message is not a object!");
                return;
            }

            if (msg.action == undefined && msg.data != undefined && msg.data.action != undefined) {
                msg.action = msg.data.action;
            }

            if (msg.action !== 8) {
                console.log("response message is not a status response message!");
                return;
            }

            var key = msg.data.status.toString();

            if (key == '2' || key == '5' || key == '6') { // vpn_sta.connected
                window.location.href = "./tips.html";
            }
        }

    },

    detectMP: function() {
        if (!MotionPro.MP_exist) {
            console.log('Please install MP client');
            return false;
        } else {
            return true;
        }
    },

    mobileDetecte: function(str) {
        var ua = detect.parse(navigator.userAgent); // 引入 detect.js
        var os = ua.os.family;
        if (os.indexOf('Android') > -1 || os.indexOf('iOS') > -1) { // mobile
            return false;
        } else {
            return true;
        }
    },
};

$(window).on('unload', function() {
    try {
        wsnotify.close();
        wscmd.close();
        console.log("websocket closed.");
    } catch(e) {
        console.log(e);
    }
});