function oauth_login() {
	if (typeof(_AN_oauth_on) != 'undefined' && _AN_oauth_on &&
		(typeof(_AN_oauth_vendor_google) != 'undefined' ||
		typeof(_AN_oauth_vendor_wechat) != 'undefined')) {
		return true;
	}

	return false;
}

function chooseAuthMethod(idx) {
    var type = _AN_aaa_method[idx].authtype;
    //server type: 0-ldap, 1-localdb, 2-radius, 3-cert, 4-kerberos, 5-externalauth, 9-smx
    if (!_AN_aaa_method[idx].multiauth) {
        $('#password1').val("");
        $('#password2').val("");
        $('#password1').parent().hide();
        $('#password2').parent().hide();
        $('label[for="password"]').text(_AN_str_password);
        if (type == 9) {
            //smx 
            $('#username').parent().show();
            $('#password').parent().hide();
            $('#chgpwd').show();
        } else if (type == 3) {
            if (_AN_aaa_method[idx].authaction == 0) {
                //anonymous cert
                $('#password').parent().hide();
                $('#username').parent().hide();
                $('#chgpwd').hide();
            } else if (_AN_aaa_method[idx].authaction == 1) {
                //challenge
                if ((_AN_aaa_method[idx].cert_id_type == "showid") && (_AN_aaa_method[idx].cert_id_value != "")) {
                    //challenge and showID
                    $('#username').parent().show();
                    $('#username').val(_AN_aaa_method[idx].cert_id_value);
                    $('#username').attr('disabled', 'disabled');
                    $('label[for="username"]').text(_AN_str_certificateID);
                } else if (_AN_aaa_method[idx].cert_id_type == "getid") {
                    $('#username').parent().show();
                    $('#username').val("");
                    $('#username').removeAttr('disabled');
                    $('label[for="username"]').text(_AN_str_certificateID);
                } else {
                    $('#username').parent().hide();
                }
                $('#password').parent().show();
                $('#chgpwd').hide();
            }
        } else {
            $('#password').parent().show();
            $('#username').parent().show();
            $('#chgpwd').hide();
        }
    } else { //multiauth
        $('#username').parent().show();
        $('#chgpwd').hide();
        $('#password1').val("");
        $('#password2').val("");
        for (i = 0; i < _AN_aaa_method[idx].multistep; i++) {
            flag = 0;
            if ((_AN_aaa_method[idx].multisteps[i].authtype == 3 && 
                _AN_aaa_method[idx].multisteps[i].action == 0) || (_AN_aaa_method[idx].multisteps[i].authtype == 9)) { //cert or smx
                flag = 1;
            }
            switch (i) {
            case 0:
                if (flag == 1) {
                    $('#password1').parent().hide();
                    $('#password1').val("xXyYzZ");
                } else {
                    $('#password1').parent().show();
                    $('label[for="password1"]').text(_AN_str_passwordServer.replace("%s", _AN_aaa_method[idx].multisteps[i].server_disp));
                    $('#password1').val("");
                }
                $('#password2').parent().hide();
                break;
            case 1:
                if (flag == 1) {
                    $('#password2').parent().hide();
                    $('#password2').val("xXyYzZ");
                } else {
                    $('#password2').parent().show();
                    $('label[for="password2"]').text(_AN_str_passwordServer.replace("%s", _AN_aaa_method[idx].multisteps[i].server_disp));
                    $('#password2').val("");
                }
                break;
            }
        }
        if (_AN_aaa_method[idx].authtype == 3 && _AN_aaa_method[idx].authaction == 0 || (_AN_aaa_method[idx].authtype == 9)) { //cert or smx
            $('#password').parent().hide();
        } else {
            $('#password').parent().show();
            $('label[for="password"]').text(_AN_str_passwordServer.replace("%s", _AN_aaa_method[idx].server_disp));
        }
    }
}
function selectOnchang(obj) {
    var value = obj.options[obj.selectedIndex].value;
    console.log(value);
    var idx = obj.selectedIndex;
    chooseAuthMethod(idx);

};
function smx_chgpwd() {
    $('#username').append('<input type="hidden" name="changepassbutton" value="chgpwd">');
    return true;
};

function download_page() {
    window.location.href = "./download.html";
}

$(function() {
    var wscmd;
    var wsnotify;
    var wsInitConnected;
    var wsInitCheckTimer;

    var login = {
        init: function() {
            this.render();
            if (_AN_hardwareid_on) {
                this.mobileDetece();
            } else {
                if (typeof(_AN_motionpro_detect_prelogin) != 'undefined' && _AN_motionpro_detect_prelogin) {
                    $('#login').attr('disabled', 'disabled');
                } else {
                    $('#login').removeAttr('disabled');
                }
            }
            this.bindEvent();
            if (MotionPro.mobileDetecte()) {
                MotionPro.init();
            }
        },

        mobileDetece: function() {
            var ua = detect.parse(navigator.userAgent);
            var os = ua.os.family;
            if (os.indexOf('Android') > -1 || os.indexOf('iOS') > -1) {
                this.handleMobile();
                return true;
            } else {
                this.ipcinit();
                return false;
            }
        },

        handleMobile: function() {
            this.errorMsg(_AN_str_h5_hwid_notsupport);
        },

        errorMsg: function(msg) {
            $('#loginMsg').text(msg);
            $('#loginMsgBox').addClass('alert-danger').removeClass('hide');
        },
        render: function() {
            if (_AN_is_motionPro_site) {
                this.errorMsg(_AN_str_motionPro_access_warning);
                $('#username').parent().hide();
                $('#password').parent().hide();
                $('label[for="method"]').parent().hide();
                $('#chgpwd').hide();
                $('#login').hide();
                return;
            }
            $('title').text(_AN_str_title_login);
            $('#title').text(_AN_str_msg_login);

            if (_AN_str_errormsg_login.length > 0) {
                if (_AN_str_errormsg_login.indexOf("msg814") >= 0) {
                    _AN_str_errormsg_login = "このデバイスは登録されていないためログインが拒否されました。このデバイスからログインするには電子メールボックス " +  _AN_str_errormsg_login.substr(6) + " のメールのリンクをクリックし、このデバイスを登録してください。";
                } else if (_AN_str_errormsg_login.indexOf("msg_cn814") >= 0) {
                    _AN_str_errormsg_login = "您的登录请求被拒绝，因为这台设备没有被注册。自动注册链接已经发送到邮箱" + _AN_str_errormsg_login.substr(9) + "，请收取邮件并点击邮件中的链接。";
                }
                this.errorMsg(_AN_str_errormsg_login);
            }

            if (oauth_login()) {
               if (typeof(_AN_oauth_vendor_google) != 'undefined') {
                   $('#an_oauth').show();
               } else {
                   $('#an_oauth').hide();
               }

               if (typeof(_AN_oauth_vendor_wechat) != 'undefined') {
                   $('#an_oauth_wechat').show();
                   if (navigator.userAgent.indexOf("NetType/") != -1) {
                       window.location="/prx/000/http/localh/oauth_wechat_auth";
                    }
               } else {
                   $('#an_oauth_wechat').hide();
               }
               $('#loginForm').hide();
               return;
            } else {
                $('#an_oauth').hide();
                $('#an_oauth_wechat').hide();
            }

            $('label[for="method"]').text(_AN_str_info_method);
            $('label[for="username"]').text(_AN_str_username);
            $('label[for="password"]').text(_AN_str_password);
            $('#login').text(_AN_str_login);
            $('#chgpwd').text(_AN_str_changepass + "(SMX)");
            $('#login').attr('disabled', 'disabled'); //check if MP is installed.

            if (_AN_aaa_method.length == 0) {
                $('.form-group').addClass('hide');
                $('#login').attr('disabled', 'disabled');
                this.errorMsg(_AN_str_method_error);

            } else {
                var options = '<select id="method" name="method" onchange="selectOnchang(this)" class="form-control selectpicker show-tick">';
                for (i = 0; i < _AN_aaa_method.length; i++) {
                    options += "<option value=\"" + _AN_aaa_method[i].name + "\">" + _AN_aaa_method[i].method_disp + "</option>";
                }
                options += '</select>'

                $('label[for="method"]').after(options);
                $('.selectpicker').selectpicker('refresh');
                $('#method').change();
            }

            if (_AN_aaa_rank_on) {
                //if had included more than one rank
                if (_AN_aaa_rank_method_idx != -1) {
                    this.choosemethod(_AN_aaa_rank_method_idx);
                } else {
                    $('label[for="method"]').parent().hide();
                }
                return;
            } else if (_AN_aaa_method.length == 1) {
                //if only one method, _AN_aaa_method_idx indicates method's index
                this.choosemethod(_AN_aaa_method_idx);
                //hide method input if there is only one method. fix bug72828
                $('label[for="method"]').parent().hide();
                return;
            }

        },
        choosemethod: function(idx) {
            chooseAuthMethod(idx);
        },

        bindEvent: function() {},

        login: function() {
            console.log($('#loginForm').serialize());
            $.post('/prx/000/http/localhost/login', $('#loginForm').serialize()).done(function() {
                location.href = '/prx/000/http/localhost/welcome/index.html';
            }).fail(function() {
                console.log('postForm error');
            });
        },

        ipcinit: function() {
            console.log("ipcinit");

            wsInitConnected = 0;

            wscmd = new WebSocket("wss://127.0.0.1:60012/ws/command");
            wsnotify = new WebSocket("wss://127.0.0.1:60012/ws/notify");

            wsInitCheckTimer = setTimeout(this.checkWebSocketStatus, 3000);

            wscmd.onopen = function(event) {
                console.log("websocket command onopen");

                wsInitConnected += 1;
                if (wsInitConnected == 2) {
                    clearTimeout(wsInitCheckTimer);
                    login.getHardwareID();
                }
            };

            wscmd.onmessage = function(event) {
                console.log("websocket command onmessage: " + event.data);
                login.showCommandResponseMessage(event.data);
            };

            wscmd.onclose = function(event) {
                console.log("websocket command onclose: " + event.data);
                wsInitConnected = 0;
            };

            wscmd.onerror = function(event) {
                console.log("websocket command onerror: " + event.data);
                clearTimeout(wsInitCheckTimer);
                wsInitConnected = 0;
                download_page();
            };

            wsnotify.onopen = function(event) {
                console.log("websocket notify onopen");
                wsInitConnected += 1;
                if (wsInitConnected == 2) {
                    clearTimeout(wsInitCheckTimer);
                    login.getHardwareID();
                }
            };

            wsnotify.onmessage = function(event) {
                console.log("\n-----------------------------------------\n");
                console.log("websocket notify onmessage: " + event.data);

            };

            wsnotify.onclose = function(event) {
                console.log("websocket notify onclose: " + event.data);
                wsInitConnected = 0;
            };

            wsnotify.onerror = function(event) {
                console.log("websocket notify onerror: " + event.data);
                wsInitConnected = 0;
            };
        },

        checkWebSocketStatus: function() {
            var ok = true;
            if (wscmd.readyState != WebSocket.OPEN) {
                console.log("websocket command is not ready!");
                ok = false;
            }
            if (wsnotify.readyState != WebSocket.OPEN) {
                console.log("websocket notify is not ready!");
                ok = false;
            }

            if (!ok) {
                wscmd.close();
                wsnotify.close();
                download_page();
            }
        },

        showCommandResponseMessage: function(data) {
            if (data == null) {
                console.log("response message is empty!");
                return;
            }

            var msg = JSON.parse(data);
            if (typeof msg != "object") {
                console.log("response message is not a object!");
                return;
            }

            if (msg.action == 13) {
                console.log("hardwardid: " + msg.data.response);
                this.handleHardwareID(msg.data.response);
                return;
            }

            if (msg.action == 15) { // handle response
                console.log("client security: " + atob(msg.data.response));
                this.parseClientSecurity(msg.data.response);
                return;
            }

            if (msg.action == undefined && msg.data != undefined && msg.data.action != undefined) {
                msg.action = msg.data.action;
            }

            if (msg.action !== 8) {
                console.log("response message is not a status response message!");
                return;
            }
        },

        getStatus: function() {
            console.log("getStatus");
            if (wsInitConnected == 0) {
                console.log("getStatus, but wsInitConnected == 0");
                location.reload();
            }

            var msg = {
                error: 0,
                message: "get vpn status from javascript",
                action: 8,
                data: {
                    action: 8
                }
            };

            wscmd.send(JSON.stringify(msg));
        },

        getHardwareID: function() {
            if (wsInitConnected == 0) {
                location.reload();
            }

            var msg = {
                error: 0,
                message: "get hardwardid from javascript",
                action: 13,
                data: {
                    action: 13,
                    type: (typeof(_AN_mp_hardwareid_type) == 'undefined'? 0 : _AN_mp_hardwareid_type)
                }
            };

            wscmd.send(JSON.stringify(msg));
        },

        handleHardwareID: function(id) {
            $('#hardwareid').val(id);
            $('#login').removeAttr('disabled');
        }

    }
    login.init();
});