/*
 * Copyright (c) 2014 CSE Co.,Ltd.
 */
if(typeof BytesToBigInteger == "undefined"){
	var BytesToBigInteger = function(inputBytes){
		this.data = null;
		this.dataLength = 0;
		var MAXLENGTH = 300;
		if(inputBytes == null){
			this.data = new Array(MAXLENGTH);
			this.dataLength = 1;
		}else{
			var input = new Array(inputBytes.length);
			for(var i = 0;i < input.length;i++){
				if(0 > inputBytes[i]){
					input[i] = 256 + inputBytes[i];
				}else{
					input[i] = inputBytes[i];
				}
			}
			this.dataLength = input.length >> 1;
			var lOver = input.length & 1;
			if(lOver != 0)
				this.dataLength++;
			this.data = new Array(MAXLENGTH);
			for(var i = input.length - 1,j = 0;i >= 1;i -= 2,j++){
				this.data[j] = ((input[i - 1] << 8) + input[i]);
			}
			if(lOver == 1){
				this.data[dataLength - 1] = input[0];
			}
			while(this.dataLength > 1 && this.data[this.dataLength - 1] == 0){
				this.dataLength--;
			}
		}
		this.toString = function(){
			var result = "";
			var a = this;
			var quotient = new BytesToBigInteger(null);
			var remainder = new BytesToBigInteger(null);
			if(a.dataLength == 1){
				result = a.data[0].toString();
			}else{
				while(a.dataLength > 1 || (a.dataLength == 1 && a.data[0] != 0)){
					singleDigit(a,10,quotient,remainder);
					result = remainder.data[0].toString() + result;
					a = quotient;
				}
			}
			return result;
		};
		function singleDigit(bi,divisor,resultQuotient,resultRemainder){
			var result = new Array(MAXLENGTH);
			var resultPos = 0;
			for(var i = 0;i < bi.data.length;i++){
				resultRemainder.data[i] = bi.data[i];
			}
			resultRemainder.dataLength = bi.dataLength;
			while(resultRemainder.dataLength > 1 && resultRemainder.data[resultRemainder.dataLength - 1] == 0){
				resultRemainder.dataLength--;
			}
			var pos = resultRemainder.dataLength - 1;
			var dividend = resultRemainder.data[pos];
			if(dividend >= divisor){
				var quotient = dividend / divisor;
				result[resultPos++] = Math.floor(quotient);
				resultRemainder.data[pos] = (dividend % divisor);
			}
			pos--;
			while(pos >= 0){
				dividend = (resultRemainder.data[pos + 1] << 16) + resultRemainder.data[pos];
				var quotient = dividend / divisor;
				result[resultPos++] = Math.floor(quotient);
				resultRemainder.data[pos + 1] = 0;
				resultRemainder.data[pos--] = (dividend % divisor);
			}
			resultQuotient.dataLength = resultPos;
			var j = 0;
			for(var i = resultQuotient.dataLength - 1;i >= 0;i--,j++){
				resultQuotient.data[j] = result[i];
			}
			for(;j < MAXLENGTH;j++){
				resultQuotient.data[j] = 0;
			}
			while(resultQuotient.dataLength > 1 && resultQuotient.data[resultQuotient.dataLength - 1] == 0){
				resultQuotient.dataLength--;
			}
			if(resultQuotient.dataLength == 0){
				resultQuotient.dataLength = 1;
			}
			while(resultRemainder.dataLength > 1 && resultRemainder.data[resultRemainder.dataLength - 1] == 0){
				resultRemainder.dataLength--;
			}
		}
	};
}
