/*
 * Copyright (c) 2014 CSE Co.,Ltd.
 */
if(typeof CryptoUtil == "undefined"){
	var root = '';
	var scripts = document.getElementsByTagName('script');
	for(var i = scripts.length - 1;i >= 0;i--){
		var match = scripts[i].src.match(/(^.*\/)CryptoUtil\.js$/);
		if (match){
			root = match[1];
			break;
		}
	}
	if(typeof BytesToBigInteger == "undefined"){
		document.write('<script type="text/javascript" src="' + root + 'BytesToBigInteger.js"></script>');
	}
	if(typeof SHA256Wrap == "undefined"){
		document.write('<script type="text/javascript" src="' + root + 'SHA256Wrap.js"></script>');
	}
	if(typeof Util == "undefined"){
		document.write('<script type="text/javascript" src="' + root + 'Util.js"></script>');
	}
	var CryptoUtil = function(){
	};
	function getHexChar(c){
		switch(c){
			case 0:
				return "0";
			case 1:
				return "1";
			case 2:
				return "2";
			case 3:
				return "3";
			case 4:
				return "4";
			case 5:
				return "5";
			case 6:
				return "6";
			case 7:
				return "7";
			case 8:
				return "8";
			case 9:
				return "9";
			case 10:
				return "A";
			case 11:
				return "B";
			case 12:
				return "C";
			case 13:
				return "D";
			case 14:
				return "E";
			case 15:
				return "F";
			default:
				return "0";
		}
	}
	CryptoUtil.arrayToHexString = function(byteData){
		var hexArray = new Array(byteData.length * 2);
		for(var i = 0;i < byteData.length;i++){
			var high = ((byteData[i] & 0xf0) >> 4);
			var low = (byteData[i] & 0x0f);
			hexArray[i * 2 + 1] = getHexChar(low);
			hexArray[i * 2] = getHexChar(high);
		}
		return hexArray.join("");
	};
	CryptoUtil.arrayToDecimalString = function(digest){
		var bi = new BytesToBigInteger(digest);
		return bi.toString();
	};
	CryptoUtil.arrayToDecimalRandom = function(digest){
		var decString = CryptoUtil.arrayToDecimalString(digest);
		var decResoultString = "";
		var figures = Math.floor(digest.length * 8.0 * (Math.log(2)/Math.log(10)));
		if(decString.length < figures){
			for(var i = 0;i < (figures - decString.length);i++){
				decResoultString += "0";
			}
			decResoultString += decString;
		}else if(figures < decString.length){
			decResoultString += decString.substring(decString.length - figures);
		}else{
			decResoultString += decString;
		}
		return decResoultString;
	};
	CryptoUtil.rotateLeftOne = function(data){
		var retData = new Array(data.length);
		var topBit = (data[0] >> 7 != 0 ? 1 : 0) & 0xFF;
		for(var i = 0;i < data.length;i++){
			var b = data[data.length - 1 - i];
			retData[data.length - 1 - i] = ((b<<1) | topBit) & 0xFF;
			topBit = (b >> 7 != 0 ? 1 : 0) & 0xFF;
		}
		return retData;
	};
	CryptoUtil.hashSHA256A = function(inputData){
		var sha256Wrap = new SHA256Wrap();
		return sha256Wrap.digest(inputData);
	};
	CryptoUtil.hashSHA256S = function(inputMessage){
		return CryptoUtil.hashSHA256A(Util.stringGetBytes(inputMessage));
	};
	function arraycopy(inv,inOff,out,outOff,todo){
		for(var i = inOff,j = outOff;i < inOff + todo;i++,j++){
			out[j] = inv[i];
		}
	}
	CryptoUtil.appendByteArray = function(source,appendix){
		if(source == null){
			source = new Array(0);
		}
		var retArray = new Array(source.length + appendix.length);
		arraycopy(source,0,retArray,0,source.length);
		arraycopy(appendix,0,retArray,source.length,appendix.length);
		return retArray;
	};
}
