/*
 * Copyright (c) 2014 CSE Co.,Ltd.
 */
if(typeof OfflineMatrixGenerator == "undefined"){
	var root = '';
	var scripts = document.getElementsByTagName('script');
	for(var i = scripts.length - 1;i >= 0;i--){
		var match = scripts[i].src.match(/(^.*\/)OfflineMatrixGenerator\.js$/);
		if (match){
			root = match[1];
			break;
		}
	}
	if(typeof DecimalFormat == "undefined"){
		document.write('<script type="text/javascript" src="' + root + 'DecimalFormat.js"></script>');
	}
	if(typeof DecimalAppearanceRatio == "undefined"){
		document.write('<script type="text/javascript" src="' + root + 'DecimalAppearanceRatio.js"></script>');
	}
	if(typeof MdlOfflineMatrix == "undefined"){
		document.write('<script type="text/javascript" src="' + root + 'MdlOfflineMatrix.js"></script>');
	}
	if(typeof CryptoUtil == "undefined"){
		document.write('<script type="text/javascript" src="' + root + 'CryptoUtil.js"></script>');
	}
	var OfflineMatrixGenerator = function(patternPrefix,loginId,enmCharCheck,enmHashType){
		var CHALLENGE_CODE_LENGTH = 256;
		var PATTERN_NO_SEPARATOR = "@";
		var HASH_TYPE_REPLACE_INDEX = 128;
		var CHAR_CHECK_REPLACE_INDEX = 255;
		var _patternPrefix = patternPrefix;
		var _loginId = loginId;
		var _generateNum = 0;
		var _enmCharCheck = enmCharCheck;
		var _enmHashType = enmHashType;
		function getPatternNo(){
			var patternNo = _patternPrefix + PATTERN_NO_SEPARATOR + _generateNum.toString();
			_generateNum++;
			return CryptoUtil.arrayToHexString(CryptoUtil.hashSHA256S(patternNo));
		}
		function generateRandomSeed(patternNo,loginId){
			var builder = "";
			builder += patternNo;
			builder += PATTERN_NO_SEPARATOR;
			builder += loginId;
			return CryptoUtil.hashSHA256S(builder);
		}
		function generateHashRandom(seed){
			return CryptoUtil.hashSHA256A(seed);
		}
		function getRandomString(randomSeed){
			var rotationSeed = randomSeed;
			var onerotSeed = CryptoUtil.rotateLeftOne(rotationSeed);
			var tworotSeed = CryptoUtil.rotateLeftOne(onerotSeed);
			var threerotSeed = CryptoUtil.rotateLeftOne(tworotSeed);
			var fourrotSeed = CryptoUtil.rotateLeftOne(threerotSeed);
			var randomData = null;
			randomData = CryptoUtil.appendByteArray(randomData,generateHashRandom(onerotSeed));
			randomData = CryptoUtil.appendByteArray(randomData,generateHashRandom(tworotSeed));
			randomData = CryptoUtil.appendByteArray(randomData,generateHashRandom(threerotSeed));
			randomData = CryptoUtil.appendByteArray(randomData,generateHashRandom(fourrotSeed));
			return CryptoUtil.arrayToDecimalRandom(randomData);
		}
		function replaceHashTypeIndex(charArray,evenChar,oddChar,enmHashType){
			if(enmHashType == OfflineMatrixGenerator.SHA256){
				charArray[HASH_TYPE_REPLACE_INDEX] = evenChar;
			}else if(enmHashType == OfflineMatrixGenerator.SHASMX){
				charArray[HASH_TYPE_REPLACE_INDEX] = oddChar;
			}
		}
		function replaceCharCheckIndex(charArray,evenChar,oddChar,enmCharCheck){
			if(enmCharCheck == OfflineMatrixGenerator.CHECK_CASE){
				charArray[CHAR_CHECK_REPLACE_INDEX] = oddChar;
			}else if(enmCharCheck == OfflineMatrixGenerator.IGNORE_CASE){
				charArray[CHAR_CHECK_REPLACE_INDEX] = evenChar;
			}
		}
		function toCharArray(str){
			var result = new Array(str.length);
			for(var i = 0;i < str.length;i++){
				result[i] = str.charAt(i);
			}
			return result;
		}
		function replaceParticularDigits(originalChallengeCode){
			var dau = new DecimalAppearanceRatio(originalChallengeCode);
			var minEven = dau.getMinAppearanceEven();
			var minEvenChar = minEven.toString().charAt(0);
			var minOdd = dau.getMinAppearanceOdd();
			var minOddChar = minOdd.toString().charAt(0);
			var charArray = toCharArray(originalChallengeCode);
			replaceHashTypeIndex(charArray,minEvenChar,minOddChar,_enmHashType);
			replaceCharCheckIndex(charArray,minEvenChar,minOddChar,_enmCharCheck);
			return charArray.join("");
		}
		function generateChallengeCode(patternNo){
			var randomSeed = generateRandomSeed(patternNo,_loginId);
			var randomStr = getRandomString(randomSeed);
			randomStr = randomStr.substring(0,CHALLENGE_CODE_LENGTH);
			var challengeCode = replaceParticularDigits(randomStr);
			return challengeCode;
		}
		function getInstanceMdlOfflineMatrix(patternNo){
			var matrix = new MdlOfflineMatrix();
			matrix.setChallengeCode(generateChallengeCode(patternNo));
			return matrix;
		}
		this.genOfflineMatrix = function(){
			return getInstanceMdlOfflineMatrix(getPatternNo());
		};
		this.genOfflineMatrixFixedGN = function(){
			_generateNum = 0;
			return this.genOfflineMatrix();
		};
		function pauseNumber(sStr){
			var sTemp = sStr;
			var len = sTemp.length;
			for(var i = 0;i < len;i++){
				if(sTemp.charAt(0) == "0"){
					sTemp = sTemp.substr(1,sTemp.length-1);
				}
			}
			if(sTemp == ""){
				sTemp = "0";
			}
			return new Number(sTemp);
		}
		function genOfflineMatrixForPatternChangeDefault(length){
			_patternPrefix = "5579062897";
			var challengeCode = genOfflineMatrixForPatternChange(length);
			return challengeCode;
		}
		function extractChallengeCode(challengeCode,length){
			return challengeCode.substring(challengeCode.length - length,challengeCode.length);
		}
		function isValidForPatternChange(challengeCode){
			var counters = new Array(10);
			var challenge = new Array(challengeCode.length);
			var c0 = "0";
			var n0 = c0.charCodeAt(0);
			for(var i = 0;i < challengeCode.length;i++){
				challenge[i] = (challengeCode.charCodeAt(i) - n0) & 0xFF;
			}
			for(var k = 0;k < counters.length;counters[k++] = 0);
			for(var i = 0;i < challenge.length;i++){
				if(counters[challenge[i]]++ >= 9){
					return false;
				}
			}
			return true;
		}
		function genOfflineMatrixForPatternChange2nd(challengeCode){
			var counters = new Array(10);
			var challenge1st = new Array(challengeCode.length);
			var c0 = "0";
			var n0 = c0.charCodeAt(0);
			for(var i = 0;i < challengeCode.length;i++){
				challenge1st[i] = (challengeCode.charCodeAt(i) - n0) & 0xFF;
			}
			var challenge2nd = new Array(challengeCode.length);
			for(var i = 0;i < counters.length;i++){
				counters[i] = 0;
			}
			for(var i = 0;i < challenge1st.length;i++){
				challenge2nd[i] = ((challenge1st[i] + ++counters[challenge1st[i]]) % 10 ) & 0xFF;
			}
			var strchallenge2nd = "";
			for(var i = 0;i < challenge2nd.length;i++){
				var tmp = (challenge2nd[i] + n0);
				strchallenge2nd += String.fromCharCode(tmp);
			}
			return strchallenge2nd;
		}
		this.genOfflineMatrixForPatternChange = function(length){
			var challengeCode = new Array(2);
			var lpatternPrefix = pauseNumber(_patternPrefix);
			var maxTrial = 10;
			var df = new DecimalFormat("0000000000");
			for(var t = 0;t < maxTrial;t++){
				_patternPrefix = df.format(lpatternPrefix);
				var mdlOfflineMatrix = this.genOfflineMatrixFixedGN();
				challengeCode[0] = extractChallengeCode(mdlOfflineMatrix.getChallengeCode(),length);
				if(isValidForPatternChange(challengeCode[0])){
					challengeCode[1] = genOfflineMatrixForPatternChange2nd(challengeCode[0]);
					return challengeCode;
				}
				lpatternPrefix++;
			}
			return genOfflineMatrixForPatternChangeDefault(length);
		};
	};
	OfflineMatrixGenerator.CHECK_CASE = 0;
	OfflineMatrixGenerator.IGNORE_CASE = 1;
	OfflineMatrixGenerator.SHA256=0;
	OfflineMatrixGenerator.SHASMX=1;
	OfflineMatrixGenerator.getCharCheck = function(strCharChk){
		if(strCharChk == "1"){
			return OfflineMatrixGenerator.CHECK_CASE;
		}
		return OfflineMatrixGenerator.IGNORE_CASE;
	};
	OfflineMatrixGenerator.getHashType = function(strHashType){
		if(strHashType == "1"){
			return OfflineMatrixGenerator.SHASMX;
		}
		return OfflineMatrixGenerator.SHA256;
	};
}
