/*
 * Copyright (c) 2014 CSE Co.,Ltd.
 */
if(typeof SHA256Digest == "undefined"){
	var SHA256Digest = function(){
		var HASH_SIZE = 32;
		var BLOCK_SIZE = 64;
		var bufOff;
		var byteCount;
		var K = new Array(
			0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5,
			0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
			0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3,
			0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
			0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc,
			0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
			0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7,
			0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
			0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13,
			0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
			0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3,
			0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
			0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5,
			0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
			0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208,
			0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2
		);
		var context = new Array(8);
		var buffer = new Array(64);
		var _buf = new Array(64);
		for(var i = 0;i < _buf.length;i++){
			_buf[i] = 0;
		}
		
		function coreReset(){
			bufOff = 0;
			byteCount = 0;
			context[0] = 0x6a09e667;
			context[1] = 0xbb67ae85;
			context[2] = 0x3c6ef372;
			context[3] = 0xa54ff53a;
			context[4] = 0x510e527f;
			context[5] = 0x9b05688c;
			context[6] = 0x1f83d9ab;
			context[7] = 0x5be0cd19;
		}
		function coreDigest(buf,off){
			for(var i = 0;i < context.length;i++){
				for(var j = 0;j < 4;j++){
					buf[off+(i * 4 + (3 - j))] = (context[i] >>> (8 * j)) & 0xFF;
				}
			}
		}
		function Ch(x,y,z){
			return (x & y) ^ (~x & z);
		}
		function Maj(x,y,z){
			return (x & y) ^ (x & z) ^ (y & z);
		}
		function Sig0(x){
			return S(2,x) ^ S(13,x) ^ S(22,x);
		}
		function Sig1(x){
			return S(6,x) ^ S(11,x) ^ S(25,x);
		}
		function sig0(x){
			return S(7,x) ^ S(18,x) ^ R(3,x);
		}
		function sig1(x){
			return S(17,x) ^ S(19,x) ^ R(10,x);
		}
		function R(off,x){
			return (x >>> off);
		}
		function S(off,x){
			return (x >>> off) | (x << (32 - off));
		}
		function coreUpdate(block,offset){
			var W = buffer;
			for(var i = 0;i < 16;i++){
				W[i] = (block[offset++]) << 24 |
						(block[offset++] & 0xFF) << 16 |
						(block[offset++] & 0xFF) <<  8 |
						(block[offset++] & 0xFF);
			}
			for(var i = 16;i < 64;i++){
				W[i] = sig1(W[i - 2]) + W[i - 7] + sig0(W[i - 15]) + W[i - 16];
				W[i] = W[i] & 0xFFFFFFFF;
			}
			var a = context[0];
			var b = context[1];
			var c = context[2];
			var d = context[3];
			var e = context[4];
			var f = context[5];
			var g = context[6];
			var h = context[7];
			for(var i = 0;i < 64;i++){
				var T1 = h + Sig1(e) + Ch(e,f,g) + K[i] + W[i];
				var T2 = Sig0(a) + Maj(a,b,c);
				h = g;
				g = f;
				f = e;
				e = d + T1;
				d = c;
				c = b;
				b = a;
				a = T1 + T2;
			}
			context[0] = (context[0] + a) & 0xFFFFFFFF;
			context[1] = (context[1] + b) & 0xFFFFFFFF;
			context[2] = (context[2] + c) & 0xFFFFFFFF;
			context[3] = (context[3] + d) & 0xFFFFFFFF;
			context[4] = (context[4] + e) & 0xFFFFFFFF;
			context[5] = (context[5] + f) & 0xFFFFFFFF;
			context[6] = (context[6] + g) & 0xFFFFFFFF;
			context[7] = (context[7] + h) & 0xFFFFFFFF;
		}
		function privateDigest(buf,offset,len,reset){
			_buf[bufOff++] = 0x80;
			var lenOfBitLen = 8;
			var C = BLOCK_SIZE - lenOfBitLen;
			if(bufOff > C){
				while(bufOff < BLOCK_SIZE){
					_buf[bufOff++] = 0x00;
				}
				coreUpdate(_buf,0);
				bufOff = 0;
			}
			while(bufOff < C){
				_buf[bufOff++] = 0x00;
			}
			var bitCount = byteCount * 8;
			for(var i = 56;i >= 0;i-=8){
				if(i >= 32){
					_buf[bufOff++] = 0;
				}else{
					_buf[bufOff++] = (bitCount >>> (i)) & 0xFF;
				}
			}
			coreUpdate(_buf,0);
			coreDigest(buf,offset);
			if(reset) coreReset();
			return HASH_SIZE;
		}
		this.extract = function(digest,offset){
			for(var i = 0;i < context.length;i++){
				digest[i + offset] = context[i];
			}
		};
		this.updateA = function(data){
			updateANN(data,0,data.length);
		};
		this.digest1 = function(){
			var tmp = new Array(HASH_SIZE);
			privateDigest(tmp,0,HASH_SIZE,true);
			return tmp;
		};
		this.digest2 = function(reset,buffer,offset){
			privateDigest(buf,offset,buffer.length,true);
		};
		this.getAlgorithmName = function(){
			return "SHA-256";
		};
		this.getDigestSize = function(){
			return HASH_SIZE;
		};
		this.updateN = function(b){
			byteCount += 1;
			_buf[bufOff++] = b;
			if(bufOff == BLOCK_SIZE){
				coreUpdate(_buf,0);
				bufOff = 0;
			}
		};
		this.updateANN = function(inv,inOff,len){
			byteCount += len;
			var todo;
			while(len >= (todo = BLOCK_SIZE - bufOff)){
				arraycopy(inv,inOff,_buf,bufOff,todo);
				var s = "";
				for(var i = 0;i < _buf.length;i++){
					s += _buf[i].toString() + ":";
				}
				coreUpdate(_buf,0);
				len -= todo;
				inOff += todo;
				bufOff = 0;
			}
			arraycopy(inv,inOff,_buf,bufOff,len);
			bufOff += len;
		};
		this.doFinal = function(out,outOff){
			privateDigest(out,outOff,HASH_SIZE,true);
			return 0;
		};
		this.reset = function(){
			coreReset();
		};
		function arraycopy(inv,inOff,out,outOff,todo){
			for(var i = inOff,j = outOff;i < inOff + todo;i++,j++){
				out[j] = inv[i];
			}
		}
		coreReset();
	};
}
