/*
 * Copyright (c) 2014 CSE Co.,Ltd.
 */
if(typeof SHASMXDigest == "undefined"){
	var SHASMXDigest = function(){
		var DIGEST_LENGTH = 20;
		var H1, H2, H3, H4, H5;
		var X = new Array(80);
		var xOff;
		var xBuf = new Array(4);
		var xBufOff;
		var byteCount;
		this.getAlgorithmName = function(){
			return "SHA-SMX";
		};
		this.getDigestSize = function(){
			return DIGEST_LENGTH;
		};
		function processWord(inv,inOff){
			X[xOff++] = ((inv[inOff] & 0xff) << 24) | ((inv[inOff + 1] & 0xff) << 16)
						 | ((inv[inOff + 2] & 0xff) << 8) | ((inv[inOff + 3] & 0xff));
			if(xOff == 16){
				processBlock();
			}
		}
		function unpackWord(word,out,outOff){
			out[outOff] = (word >>> 24) & 0xFF;
			out[outOff + 1] = (word >>> 16) & 0xFF;
			out[outOff + 2] = (word >>> 8) & 0xFF;
			out[outOff + 3] = word & 0xFF;
		}
		function processLength(bitLength){
			if(xOff > 14){
				processBlock();
			}
			X[14] = 0;
			X[15] = (bitLength & 0xffffffff);
		}
		this.doFinal = function(out,outOff){
			this.finish();
			unpackWord(H1, out, outOff);
			unpackWord(H2, out, outOff + 4);
			unpackWord(H3, out, outOff + 8);
			unpackWord(H4, out, outOff + 12);
			unpackWord(H5, out, outOff + 16);
			this.reset();
			return DIGEST_LENGTH;
		};
		this.reset = function(){
			byteCount = 0;
			xBufOff = 0;
			for(var i = 0;i < xBuf.length;i++){
				xBuf[i] = 0;
			}
			H1 = 0x67452301;
			H2 = 0xefcdab89;
			H3 = 0x98badcfe;
			H4 = 0x10325476;
			H5 = 0xc3d2e1f0;
			xOff = 0;
			for(var i = 0;i != X.length;i++){
				X[i] = 0;
			}
		};
		var Y1 = 0x5a827999;
		var Y2 = 0x6ed9eba1;
		var Y3 = 0x8f1bbcdc;
		var Y4 = 0xca62c1d6;
		function f(u,v,w){
			return ((u & v) | ((~u) & w));
		}
		function h(u,v,w){
			return (u ^ v ^ w);
		}
		function g(u,v,w){
			return ((u & v) | (u & w) | (v & w));
		}
		function rotateLeft(x,n){
			return ((x << n) & 0xFFFFFFFF) | ((x >>> (32 - n)) & 0xFFFFFFFF);
		}
		function processBlock(){
			for(var i = 16;i <= 79;i++){
				X[i] = rotateLeft((X[i - 3] ^ X[i - 8] ^ X[i - 14] ^ X[i - 16]),1);
			}
			var A = H1;
			var B = H2;
			var C = H3;
			var D = H4;
			var E = H5;
			for(var j = 0;j <= 19;j++){
				var t = rotateLeft(A,5) + f(B,C,D) + E + X[j] + Y1;
				E = D & 0xFFFFFFFF;
				D = C & 0xFFFFFFFF;
				C = rotateLeft(B,30) & 0xFFFFFFFF;
				B = A & 0xFFFFFFFF;
				A = t & 0xFFFFFFFF;
			}
			for(var j = 20;j <= 39;j++){
				var t = rotateLeft(A,5) + h(B,C,D) + E + X[j] + Y2;
				E = D & 0xFFFFFFFF;
				D = C & 0xFFFFFFFF;
				C = rotateLeft(B,30) & 0xFFFFFFFF;
				B = A & 0xFFFFFFFF;
				A = t & 0xFFFFFFFF;
			}
			for(var j = 40;j <= 59;j++){
				var t = rotateLeft(A,5) + g(B,C,D) + E + X[j] + Y3;
				E = D & 0xFFFFFFFF;
				D = C & 0xFFFFFFFF;
				C = rotateLeft(B,30) & 0xFFFFFFFF;
				B = A & 0xFFFFFFFF;
				A = t & 0xFFFFFFFF;
			}
			for(var j = 60;j <= 79;j++){
				var t = rotateLeft(A,5) + h(B,C,D) + E + X[j] + Y4;
				E = D & 0xFFFFFFFF;
				D = C & 0xFFFFFFFF;
				C = rotateLeft(B,30) & 0xFFFFFFFF;
				B = A & 0xFFFFFFFF;
				A = t & 0xFFFFFFFF;
			}
			H1 = (H1 + A) & 0xFFFFFFFF;
			H2 = (H2 + B) & 0xFFFFFFFF;
			H3 = (H3 + C) & 0xFFFFFFFF;
			H4 = (H4 + D) & 0xFFFFFFFF;
			H5 = (H5 + E) & 0xFFFFFFFF;
			xOff = 0;
			for(var i = 0;i != X.length;i++){
				X[i] = 0;
			}
		}
		this.updateN = function(inv){
			xBuf[xBufOff++] = inv;
			if(xBufOff == xBuf.length){
				processWord(xBuf,0);
				xBufOff = 0;
			}
			byteCount++;
		};
		this.updateANN = function(inv,inOff,len){
			while((xBufOff != 0) && (len > 0)){
				this.updateN(inv[inOff]);
				inOff++;
				len--;
			}
			while(len > xBuf.length){
				processWord(inv,inOff);
				inOff += xBuf.length;
				len -= xBuf.length;
				byteCount += xBuf.length;
			}
			while(len > 0){
				this.updateN(inv[inOff]);
				inOff++;
				len--;
			}
		};
		this.finish = function(){
			var bitLength = (byteCount << 3);
			this.updateN(128);
			while(xBufOff != 0){
				this.updateN(0);
			}
			processLength(bitLength);
			processBlock();
		};
		this.reset();
	};
}
