/*
 * Copyright (c) 2014 CSE Co.,Ltd.
 */
if(typeof Util == "undefined"){
	var root = '';
	var scripts = document.getElementsByTagName('script');
	for(var i = scripts.length - 1;i >= 0;i--){
		var match = scripts[i].src.match(/(^.*\/)CryptoUtil\.js$/);
		if (match){
			root = match[1];
			break;
		}
	}
	if(typeof CNSTD == "undefined"){
		document.write('<script type="text/javascript" src="' + root + 'CNSTD.js"></script>');
	}
	if(typeof SHA256Digest == "undefined"){
		document.write('<script type="text/javascript" src="' + root + 'SHA256Digest.js"></script>');
	}
	if(typeof SHA1Digest == "undefined"){
		document.write('<script type="text/javascript" src="' + root + 'SHASMXDigest.js"></script>');
	}
	var Util = function(){
	};
	Util.getDispBoxImage = function(numbox,nums,dispbox){
		if(nums.length != CNSTD.TOTBOX * CNSTD.BOXLINE * CNSTD.BOXCOL){
			return false;
		}
		if(numbox != dispbox.length){
			return false;
		}
		for(var i = 0;i < numbox;i++){
			if(dispbox[i].length != CNSTD.BOXLINE){
				return false;
			}
			for(var j = 0;j < dispbox[i].length;j++){
				var dispbox1 = dispbox[i];
				if(dispbox1[j].length != CNSTD.BOXCOL){
					return false;
				}
			}
		}
		var posi = Util.getPosition(nums);
		var s = 0 ;
		for(var i = 0;i < numbox;i++){
			var dispbox1 = dispbox[i];
			for(var j = 0;j < CNSTD.BOXLINE;j++){
				var dispbox2 = dispbox1[j];
				for(var k = 0;k < CNSTD.BOXCOL;k++){
					if(posi + s < nums.length) dispbox2[k] = nums[posi + s++];
					else dispbox2[k] = nums[posi + s++ - nums.length];
				}
			}
		}
		return true;
	};
	function unsigned2singedByte(b){
		var ret = b;
		if (b & 0x80){
			ret = b - 256;
		}
		return ret;
	}
	function getSum(num){
		var numcycl = new Array(CNSTD.SUMUNIT*2);
		for(var i = 0;i < CNSTD.SUMUNIT * 2 ;i++){
			if(i < CNSTD.SUMUNIT){
				numcycl[i] = num[num.length - CNSTD.SUMUNIT + i];
			}else{
				numcycl[i] = num[i - CNSTD.SUMUNIT];
			}
		}
		var sum = 0;
		var tmp = 0;
		for(var i = 0;i < num.length;i++){
			tmp = 0;
			var order = 1;
			for(var j = 0;j < CNSTD.SUMUNIT;j++){
				if(i < num.length - CNSTD.SUMUNIT) tmp += num[i + j] * order;
				else tmp += numcycl[i - (num.length - CNSTD.SUMUNIT) + j] * order;
				order *= 10;
			}
			sum += tmp;
		}
		return sum;
	}
	Util.getPosition = function(nums){
		var sum = getSum(nums);
		var posi = sum % nums.length;
		return posi;
	};
	function byteToHexString(b){
		var hexDigits = new Array("0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f");
		var n = b;
		if(n < 0){
			n = 256 + n;	
		}
		var d1 = Math.floor(n / 16);
		var d2 = n % 16;
		return hexDigits[d1] + hexDigits[d2];
	}
	function byteArrayToHexString(ba){
		var result = "";
		for(var i = 0;i < ba.length;i++){
			result += byteToHexString(unsigned2singedByte(ba[i]));
		}
		return result;
	}
	Util.getHash = function(pswdstr,challenge){
		if((challenge[challenge.length-1] % 2) == 0){
			pswdstr = pswdstr.toUpperCase();
		}
		var concatstr = "";
		concatstr += pswdstr;
		for(var i = 0;i < challenge.length;i++){
			concatstr += challenge[i].toString();
		}
		var hexstring = "";
		if((challenge[challenge.length/2] % 2) == 0){
			var hasher = new SHA256Digest();
			hasher.updateANN(Util.stringGetBytes(concatstr),0,concatstr.length);
			var hashBA = new Array(hasher.getDigestSize());
			hasher.doFinal(hashBA,0);
			hexstring = byteArrayToHexString(hashBA);
		}else{
			var hasher = new SHAS<XDigest();
			hasher.updateANN(Util.stringGetBytes(concatstr),0,concatstr.length);
			var hashBA = new Array(hasher.getDigestSize());
			hasher.doFinal(hashBA,0);
			hexstring = byteArrayToHexString(hashBA);
		}
		return hexstring;
	};
	Util.getRegBoxImage = function(time,numbox,nums,dispbox){
		if(time < 1 || time > 2){
			return false;
		}
		if(nums.length < 2 * numbox * CNSTD.BOXLINE * CNSTD.BOXCOL){
			return false;
		}
		if(dispbox.length != numbox){
			return false;
		}
		for(var i = 0;i < numbox;i++){
			if(dispbox[i].length != CNSTD.BOXLINE){
				return false;
			}
			for(var j = 0;j < CNSTD.BOXLINE;j++){
				if(dispbox[i][j].length != CNSTD.BOXCOL){
					return false;
				}
			}
		}
		var s = (time - 1) * numbox * CNSTD.BOXLINE * CNSTD.BOXCOL;
		var temp = "";
		for(var i = 0;i < numbox;i++){
			for(var j = 0;j < CNSTD.BOXLINE;j++){
				for(var k = 0;k < CNSTD.BOXCOL;k++){
					dispbox[i][j][k] = nums[s++];
					temp = temp + ":" + dispbox[i][j][k];
				}
			}
		}
		return true;
	};
	Util.digit = function(ch,radix){
		var ch0 = "0";
		var ch9 = "9";
		var chsa = "a";
		var chsz = "z";
		var chla = "A";
		var chlz = "Z";
		var nch = ch.charCodeAt(0);
		if(nch >= ch0.charCodeAt(0) && nch <= ch9.charCodeAt(0)){
			return nch - ch0.charCodeAt(0);
		}
		if(radix == 16){
			if(nch >= chsa.charCodeAt(0) && nch <= chsz.charCodeAt(0)){
				return nch - chsa.charCodeAt(0) + 10;
			}
			if(nch >= chla.charCodeAt(0) && nch <= chlz.charCodeAt(0)){
				return nch - chla.charCodeAt(0) + 10;
			}
		}
		return -1;
	};
	Util.stringGetBytes = function (str){
		var result = new Array();
		var count = 0;
		for(var i = 0;i < str.length;i++){
			var c = str.charCodeAt(i);
			result[count++] = c & 0xFF;
			if(c & 0xFF00){
				result[count++] = (c & 0xFF00) >>> 8;
			}
		}
		return result;
	};

}
