var host_list = [];

var cookies = {
    uname: _AN_username,
    role: '',
    sso_uname: '',
    session: _AN_sessionid,
    siteid: _AN_vsite_name
};

var artData = {
    instid: '',
    powermng: '',
    vdiauth: '',
    vdiuser: '',
    vdipwd: '',
    vdidomin: '',
    port: '',
    screensize: '',
    colorDepth: '',
    desktopwall: '',
    fullwindowdrag: '',
    menuanim: '',
    themes: '',
    audiomode: '',
    rdrive: '',
    rprinter: ''
};

var RDP_serverIP = '';

var DD = {
    newTab: '',

    getCookie: function(name) {
        var arr = document.cookie.match(new RegExp('(^| )' + name + '=([^;]*)(;|$)'));
        if (arr != null) {
            return decodeURI(arr[2]);
        }
        return null
    },

    getRdpIP: function() {
        if (_AN_guacamole_url.length > 0) {
            var res = _AN_guacamole_url.split('//');
            res = res[1].split('/');
            RDP_serverIP = res[0];
            console.log('_AN_guacamole_url', RDP_serverIP);
        }
    },

    getRole: function() {
        if (!this.getCookie('role_names')) {
            cookies.role = '';
        } else {
            var tmp = this.getCookie('role_names');
            cookies.role = tmp.replace(/\,/, ':');
        }
    },

    getSso_uname: function() {
        if (!this.getCookie('sso_uname')) {
            cookies.sso_uname = cookies.uname;
        } else {
            cookies.sso_uname = this.getCookie('sso_uname');
        }
    },

    ipDetecte: function(str) {
        var patt = new RegExp(/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/);
        var res = patt.test(str);
        return res;
    },

    getBaseInfo: function() {
        this.getRole();
        this.getSso_uname();
        this.hostInfoMsg(_AN_str_retrieving);

        var infoUrl = '/prx/000/http/localhost:9090/query/info?_uname=' + cookies.sso_uname + '&_sessid=' + cookies.session;
        $.get(infoUrl).done(function(xml) {
            var $xmlDoc = $(xml);
            artData.instid = $xmlDoc.find('Instance').text() || '';
            artData.vdiauth = $xmlDoc.find('vdiauth').text() || '';
            artData.vdiauth = parseInt(artData.vdiauth);
            DD.getHosts();
        }).fail(function() {
            console.log('getBaseInfo error!!!');
        })
    },

    regLocalPC: function(description) {
        this.getRole();
        this.getSso_uname();
        this.hostInfoMsg(_AN_str_retrieving);

        var regUrl = '/prx/000/http/localhost:9090/portal/regreq';
        var regForm = $("#ddreg_iframe").contents().find("#ddreg_form");
        $("#ddreg_iframe").contents().find("#_desc").val(description);
        $("#ddreg_iframe").contents().find("#_instid").val(artData.instid);
        $("#ddreg_iframe").contents().find("#_signature").val(local_pc_name);
        $("#ddreg_iframe").contents().find("#_extraparams").val(dd_reg_extraparm);
        $("#ddreg_iframe").contents().find("#_uname").val(cookies.sso_uname);
        regForm.submit();
    },

    override_regLocalPC: function(params) {
        this.getRole();
        this.getSso_uname();
        this.hostInfoMsg(_AN_str_retrieving);
        var regUrl = '/prx/000/http/localhost:9090/portal/regreq';
        $.post(regUrl, {
            _override: 1,
            _signature: local_pc_name,
            _params: params
        },
        function(data, status) {
            alert("Data: " + data + "\nStatus: " + status);
        });

    },

    getHosts: function() {
        var hostUrl = '/prx/000/http/localhost:9090/query/hosts?_uname=' + cookies.sso_uname + '&_role=' + cookies.role + '&_instid=' + artData.instid;
        if (true) {//artData.vdiauth != 1) {
            DD.renderHosts(hostUrl);
        } else {
            $.get('./dialog/vdiuser_login.html').done(function(data) {
                $('#logBox').html(data).modal('show');
                var $vdiDoc = $('#logBox');
                $('#vdiLogin').on('click',
                function() {
                    artData.vdiauth = $vdiDoc.find('#name').val() || '';
                    artData.vdipwd = $vdiDoc.find('#pwd').val() || '';
                    hostUrl += '&_vdiuser=' + artData.vdiauth + '&_vdipwd=' + artData.vdipwd;

                    $('#logBox').modal('hide');
                });
                $('#pwd').on('keyup',
                function(e) {
                    if (e.keyCode === 13) { // entry keyup
                        artData.vdiuser = $vdiDoc.find('#name').val() || '';
                        artData.vdipwd = $vdiDoc.find('#pwd').val() || '';
                        hostUrl += '&vdiuser=' + artData.vdiuser + '&vdipwd=' + artData.vdipwd;

                        $('#logBox').modal('hide');
                    }
                });

                $('#logBox').on('hidden.bs.modal',
                function(e) { // dialog hidden toggles
                    DD.renderHosts(hostUrl);
                });
            })
        }
    },

    renderHosts: function(url) {
        $.get(url).done(function(xml) {
            var $xmlDoc = $(xml);

            artData.port = $xmlDoc.find('Hosts').attr('RDPPort');
            artData.powermng = $xmlDoc.find('powermng').text() || '';
            artData.powermng = parseInt(artData.powermng);
            artData.screensize = $xmlDoc.find('screensize').text() || '';
            artData.colorDepth = $xmlDoc.find('colorDepth').text() || '';
            artData.desktopwall = $xmlDoc.find('desktopwall').text() || '';
            artData.fullwindowdrag = $xmlDoc.find('fullwindowdrag').text() || '';
            artData.menuanim = $xmlDoc.find('menuanim').text() || '';
            artData.themes = $xmlDoc.find('themes').text() || '';
            artData.audiomode = $xmlDoc.find('audiomode').text() || '';
            artData.rdrive = $xmlDoc.find('rdrive').text() || '';
            artData.rprinter = $xmlDoc.find('rprinter').text() || '';
            var hosts = $xmlDoc.find('Host');

            if (hosts.length == 0) {
                $('#nav_rdplinks').addClass('hide');
            } else {
                for (var i = 0; i < hosts.length; i++) {
                    host_list[i] = {};
                    host_list[i].index = i;
                    host_list[i].port = $(hosts[i]).attr('Port') || artData.port;
                    host_list[i].id = $(hosts[i]).attr('ID') || '';
                    host_list[i].host = $(hosts[i]).attr('ID') || '';
                    host_list[i].desc = $(hosts[i]).attr('Desc') || '';
                    host_list[i].prov = $(hosts[i]).attr('Provider') || '';
                    host_list[i].provid = $(hosts[i]).attr('ProviderID') || '';
                    host_list[i].param = $(hosts[i]).attr('Params') || '';
                    host_list[i].icon = '../login/static/images/desktop.png';
                    host_list[i].img = $(hosts[i]).attr('Loc') ? '/prx/000/http/127.0.0.1:9090/query/appicon?_appid=' + host_list[i].id: '../login/static/images/desktop.png';
                    // XenDesktop to IP
                    if (host_list[i].prov === 'XenDesktop') {
                        host_list[i].host = $xmlDoc.find("ProvParams[ID='" + host_list[i].id + "'] > CtlIP").text();
                    }
                    $('#hosts').html(_.template($('#dd_tpl').html(), host_list));
                    DD.closeHostMsg();
                }
            }
        }).fail(function() {
            console.log('GetHost error');
        }).always(function() {
            DD.bindEvents();
        });
    },

    addRdpParams: function(url) {
        if (artData.screensize != '' && artData.screensize != '0X0') {
            var arr = artData.screensize.split();
            var width = arr[0];
            var height = arr[1];
            url += '&w=' + width + '&h=' + height;
        }
        if (artData.colorDepth != '' && artData.colorDepth != '0') {
            url += '&c=' + artData.colorDepth;
        }
        if (artData.desktopwall === '0') {
            url += '&wp=false';
        } else if (artData.desktopwall === '1') {
            url += '&wp=true';
        }
        if (artData.fullwindowdrag === '0') {
            url += '&fwd=false';
        } else if (artData.fullwindowdrag === '1') {
            url += '&fwd=true';
        }
        if (artData.menuanim === '0') {
            url += '&ma=false';
        } else if (artData.menuanim === '1') {
            url += '&ma=true';
        }
        if (artData.themes === '0') {
            url += '&th=false';
        } else if (artData.themes === '1') {
            url += '&th=true';
        }
        if (artData.audiomode === '2') {
            url += '&da=true';
        }
        if (artData.rdrive === '0') {
            url += '&ed=false';
        } else if (artData.rdrive === '1') {
            url += '&ed=true';
        }
        if (artData.rprinter === '0') {
            url += '&ep=false';
        } else if (artData.rprinter === '1') {
            url += '&ep=true';
        }
        return url;
    },

    bindEvents: function() {
        $('#hosts').on('click', this.hostInit.bind(this));
        $('#closeHostMsg').on('click',
        function() {
            $('#hostMsgBox').addClass('hide');
        })
    },

    hostInit: function(e) {
        var $a = $(e.target);
        var i = $a.data('index');
        var host = host_list[i];
        var icon = '#load-' + i;
        $(icon).removeClass('hide');
        this.getRdpIP();
        host.checkUrl = '/prx/000/http/localhost:65200/rdp/avail.php?siteid=' + cookies.siteid + '&id=' + host.id;

        if (host.prov != '') // vmview
        host.checkUrl += '&provider=' + host.prov;

        if (artData.vdiauth === 1) {
            host.checkUrl += '&vdiuser=' + artData.vdiuser + '&vdipwd=' + artData.vdipwd;
        }

        if (RDP_serverIP.length > 0) {
            if (this.ipDetecte(host.host)) { // is IP address (include XenDesktop)
                this.checkSta(i);
            } else {
                this.host2Ip(i);
            }
        } else {
            this.hostErrorMsg(host.desc + ': Not configured Guacamole url');
            $(icon).addClass('hide');
        }

    },

    host2Ip: function(i) {
        var host = host_list[i];

        $.get(host.checkUrl).done(function(xml) {
            var $xmlDoc = $(xml);
            host.host = $xmlDoc.find('StateSess').attr('Host') || host.id;

            if (DD.ipDetecte(host.host)) {
                DD.checkSta(i);
                console.log(i);
                DD.closeHostMsg();
            } else {
                var icon = '#load-' + i;
                $(icon).addClass('hide');
                var msg = _AN_str_case7 + host.desc + ')';
                DD.hostErrorMsg(msg);
            }

        }).fail(function() {
            var icon = '#load-' + i;
            $(icon).addClass('hide');
            var msg = _AN_str_case7 + host.desc + ')';
            DD.hostErrorMsg(msg);
        })
    },

    checkSta: function(i) {
        var sta = 0,
        time = 0,
        host = host_list[i];
        this.newTab = window.open('./loading.html');
        this.hostInfoMsg(_AN_str_initializing);

        $.get(host.checkUrl).done(function(xml) {
            var $xmlDoc = $(xml);
            sta = $xmlDoc.find('StateSess').attr('State');
            console.log(sta);

            if (sta == 3) {
                console.log('conneting...');
                DD.closeHostMsg();
                DD.toRDP(i);
            } else if (sta == 1) { // wake-up mode
                setTimeout(function() {
                    DD.newTab.close();
                },
                2000);

                if (artData.powermng != 1) {
                    var icon = '#load-' + i;
                    $(icon).addClass('hide');

                    var msg = host.desc + ':' + _AN_str_turn_off;
                    DD.hostErrorMsg(msg);

                } else {
                    // not vmview
                    if (host.prov != 'VMVIEW') {
                        console.log('waking up...');
                        DD.wakeUp(i);
                    } else {
                        var icon = '#load-' + i;
                        $(icon).addClass('hide');

                        var msg = host.desc + ':' + _AN_str_turn_off;
                        DD.hostErrorMsg(msg);
                    }
                }

            } else if (sta == 4) {
                var icon = '#load-' + i;
                $(icon).addClass('hide');

                var msg = host.desc + ':' + _AN_str_case18;
                DD.hostErrorMsg(msg);
            }
        })
    },

    toRDP: function(i) {
        var host = host_list[i];

        host.rdpUrl = '/prx/000/http/' + RDP_serverIP + '/g/index.html?hs=' + host.host + '&p=' + host.port + '&u=AG_USERNAME_FOR_GUACAMOLE_DESKTOP&s=AG_PASSWORD_FOR_GUACAMOLE_DESKTOP';
        host.rdpUrl = this.addRdpParams(host.rdpUrl);

        var icon = '#load-' + i;
        setTimeout(function() {
            $(icon).addClass('hide');
        },
        1500);
        DD.closeHostMsg()

        this.newTab.location.href = host.rdpUrl;
    },

    wakeUp: function(i) {
        var host = host_list[i];
        host.wakeUrl = '/prx/000/http/127.0.0.1:9090/object/powerup?_instid=' + artData.instid + '&_objid=' + host.host + '&_uname=' + cookies.sso_uname + '&_prov=' + host.prov + '&_provid=' + host.provid + '&_deskid=%s&_desc=' + host.desc;
        $.get('./dialog/wakeup_confirm.html').done(function(data) {
            $('#wakeBox').html(data).modal('show');
            $('#cancel').on('click',
            function() {
                console.log('power up cancel');
                var icon = '#load-' + i;
                $(icon).addClass('hide');
                DD.closeHostMsg();
            });
            $('#wakeUp').on('click',
            function() {
                DD.hostInfoMsg(_AN_str_power_up);
                $.get(host.wakeUrl).done(function(res) {
                    $res = $(res);
                    host.sessId = $res.find('StateSess').attr('ID');
                    host.loopStaUrl = '/prx/000/http/127.0.0.1:9090/query/avail?_instid=' + artData.instid + '&_sessid=' + host.sessId + '&_objid=' + host.id + '&_port=' + host.port + '&_prov=' + host.prov + '&_provid=' + host.provid + '&_deskid=' + host.provid + '&_uname=' + cookies.uname;

                    DD.timeout = setInterval(function() {
                        DD.loopSta(i)
                    },
                    10000);
                    $('#wakeBox').modal('hide');
                    console.log("wakeup-checkSta");
                })
            })
        })
    },

    loopSta: function(i) {
        var host = host_list[i];

        $.get(host.loopStaUrl).done(function(res) {
            var $res = $(res);
            sta = $res.find('StateSess').attr('State');

            if (sta != '2') {
                clearInterval(DD.timeout);
            }

            if (sta == 4) {
                var icon = '#load-' + i;
                $(icon).addClass('hide');

                var msg = host.desc + ':' + _AN_str_case18;
                DD.hostErrorMsg(msg);
            } else if (sta == 3) { // maybe sta == 3
                DD.checkSta(i);
            }

        }).fail(function() {

})
    },

    hostInfoMsg: function(msg) {
        $('#hostMsg').text(msg);
        $('#hostMsgBox').addClass('alert-info').removeClass('hide');
    },

    hostErrorMsg: function(msg) {
        $('#hostMsg').text(msg);
        $('#hostMsgBox').addClass('alert-danger').removeClass('hide');
    },

    closeHostMsg: function() {
        $('#hostMsgBox').addClass('hide');
    },

    init: function() {
        this.getBaseInfo();
    },
    regPC: function(description) {
        this.regLocalPC(description);
    },
    override_regPC: function(params) {
        this.override_regLocalPC(params);
    }

};

jQuery(function($) {

    $.ajaxSetup({
        cache: false
    })

    if (_AN_show_desktop) {
        DD.init();
        $('#DDreg').on('click',
        function() {
            $('#DDreg').attr('disabled','disabled');
            DD.getHosts();
            setTimeout(function() {
                    MotionPro.getLocalPcName();
                },
                1500);
        });
    }

})