(function (exports) {
    var fileProxy = _AN_file_server_url.split('//')[1];
    var dirIndex = 'dav/10.3.0.57/OpenKM/webdav/';
    
    exports.app = new Vue({
        el: '#fs',

        data: {
            haveFile: true,
            fileList: [],
        },

        mounted: function () {
            this.$nextTick(function () {
                this.initGetFile();
            })
        },

        methods: {
            initGetFile: function () {
                var _this = this;
                var hash = window.location.hash.substr(1);
                if (hash.length > 1) {
                    hash += '/';
                }
                url = '/prx/000/http/' + fileProxy + '/api/v1/fileproxy/-/' + dirIndex + hash + '?json=1';
                axios.get(url)
                    .then(function (res) {
                        console.log(res.data);
                        _this.fileList = res.data.data;
                        if (!res.data.data.length) {
                            _this.haveFile = false;
                        }
                    });
            },
            getFileServer: function (item) {
                var _this = this;
                var hash = window.location.hash.substr(1) + '/';
                url = '/prx/000/http/' + fileProxy + '/api/v1/fileproxy/-/' + dirIndex + hash + item.name + '/?json=1';
                console.log(url);
                axios.get(url)
                    .then(function (res) {
                        window.location.hash += '/' + item.name;
                        _this.fileList = res.data.data;
                        if (!res.data.data.length) {
                            _this.haveFile = false;
                        }
                    });
                
            },
            getDocument: function (item) {
                var _this = this;
                var hash = window.location.hash.substr(1) + '/';
                url = '/prx/000/http/' + fileProxy + '/api/v1/fileproxy/-/' + dirIndex + hash + item.name + '?json=1';
                console.log(url);
                window.open(url);
            }
        },

        watch: {

        }

    })
})(window);
