(function (exports) {
    
    exports.header = new Vue({
        el: '.header',
        data: {
            title: ''
        },

        mounted: function () {
            this.$nextTick(function (){
                this.render();
            });
        },

        methods: {
            render: function () {
                this.title = _AN_str_h5_edit_bookmark;
            }
        }
    });

    exports.form = new Vue({
        el: '.bookmark-form',
        data: {
            id: '',
            url: '',
            placeholder: '',
            description: '',
            type: 0,
            enableFile: '',
            enableFileshare: '',
            enableDesktop: '',
            hide_format: true,
            lang: {
                desc_str: '',
                type_str: '',
                weblink_str: '',
                filelink_str: '',
                desktop_str: '',
                filesystem_str: '',
                edit_str: '',
                cancel_str: '',
                comfirm_str: '',
                format_str: '',
            }
        },

        mounted: function () {
            this.$nextTick(function () {
                this.render();
                this.getBookInfo();
            });
        },
        computed: {
            format_url: function () {
                if (this.type == 0) {
                    return 0;
                } else if (this.type == 1) {
                    return 1;
                } else if (this.type == 2) {
                    return 2;
                } else {
                    return 3;
                }
            }
        },      
        methods: {
            render: function () {
                this.lang.desc_str = _AN_str_description.split(':')[0];
                this.lang.type_str = _AN_str_type.split(':')[0];
                this.lang.weblink_str = _AN_str_weblink;
                this.lang.filelink_str = _AN_str_filelink;
                this.lang.desktop_str = _AN_str_desktop;
                this.lang.filesystem_str = '文件系统';
                this.lang.edit_str = _AN_str_h5_edit;
                this.lang.cancel_str = _AN_str_cancel;
                this.lang.comfirm_str = '确定';
                this.lang.format_str = _AN_str_format.split(':')[0];

                this.enableFile = _AN_file_server_url.length ? true : false;
                this.enableFileshare = _AN_enable_fileshare;
                this.enableDesktop = !!(_AN_show_desktop && _AN_guacamole_url.length);

            },
            showFormat: function () {
                this.hide_format = false;
            },
            hideFormat: function () {
                this.hide_format = true;
            },
            getBookInfo: function () {
                var _this = this;
                var queryStr = window.location.href.split('?')[1];
                var params = new URLSearchParams(queryStr);
                var bookID = params.get('id');
                var url = '/prx/000/http/localh:65200/motionpro/postlogin/bookmark?action=list&id=' + bookID;

                axios.get(url).then(function (res){
                    console.log(res.data);
                    var obj = {};
                    var str = res.data.split(',');
                    obj.url = str[0].split('url')[1].split('"')[2];
                    obj.desc = str[1].split(':')[1].split('"')[1];
                    obj.id = str[3].split(':')[1].split('"')[1];
                    obj.type = str[4].split(':')[1].split('"')[1];

                    _this.id = obj.id;
                    _this.description = obj.desc;
                    if (obj.url.indexOf('/api/v1/fileproxy/-/') > -1) {
                        _this.type = '3';
                        _this.url = _this.handleUrl(obj.url.split('/api/v1/fileproxy/-/')[1]);
                    } else {
                        _this.type = obj.type;
                        _this.url = obj.url;
                    }
                })
            },

            handleUrl: function (url) {
                var res;
                var protocol = url.split('/')[0];
                if (protocol == 'davs') {
                    res = 'https://' + url.substr(5);
                } else if (protocol == 'dav') {
                    res = 'http://' + url.substr(4);
                } else if (protocol == 'smb') {
                    res = '//' + url.substr(4);
                } else {
                    res = protocol + ':/' + url.substr(protocol.length);
                }
                return res;
            },

            editBook: function () {
                var params = new URLSearchParams();
                var postURL = '/prx/000/http/localh:65200/motionpro/postlogin/bookmark?action=edit';
                if (this.type == 3) {
                    params.append('type', 0);
                    var parseUrl = this.parseUrl(this.url);
                    var fileUrl = '/api/v1/fileproxy/-/' + parseUrl;
                    params.append('url', fileUrl);
                } else {
                    params.append('url', this.url);
                    params.append('type', this.type);
                }
                params.append('description', this.description);
                params.append('id', this.id);
                console.log(params);

                axios.post(postURL, params).then(function () {
                    window.location.href = './index.html';
                }).catch(function () {
                    console.log('Add bookmark error!!!');
                })
            },
            parseUrl: function (str) {
                var res, protocol, host;
                str = str.trim();
                if (str.indexOf('://') > -1) {
                    protocol = str.split('://')[0];
                    host = '/' + str.split('://')[1];
                    if (protocol == 'http') {
                        protocol = 'dav';
                    } else if (protocol == 'https') {
                        protocol = 'davs';
                    }
                    res = protocol + host;
                    
                } else if (str.indexOf('//') > -1) {
                    protocol = 'smb/';
                    host = str.split('//')[1];
                    res = protocol + host;
                } else {
                    res = str;
                }

                if(res.substr(-1) != '/') {
                    res += '/';
                }
                return res;
            }
        }
    })

})(window);
