(function (exports) {
    var fileProxy = _AN_file_server_url.split('//')[1].split('/')[0];

    var iconMap = {
        'xls': 'an-excel-o',
        'xlsx': 'an-excel-o',
        'html': 'an-html-o',
        'htm': 'an-html-o',
        'pdf': 'an-pdf-o',
        'ppt': 'an-ppt-o',
        'pptx': 'an-ppt-o',
        'doc': 'an-word-o',
        'docx': 'an-word-o',
        'rar': 'an-reduce-o',
        'zip': 'an-reduce-o',
        'jpg': 'an-photo-o',
        'jpeg': 'an-photo-o',
        'png': 'an-photo-o',
        'gif': 'an-photo-o',
        'txt': 'an-txt-o',
        'pdf': 'an-pdf-o',
        'mp3': 'an-audio-o',
        'ape': 'an-audio-o',
        'flac': 'an-audio-o',
        'wav': 'an-audio-o',
        'mp4': 'an-video-o',
        'avi': 'an-video-o',
        'mov': 'an-video-o',
        'rmvb': 'an-video-o',
        'mkv': 'an-video-o',
        'other': 'an-file-o'
    }

    exports.app = new Vue({
        el: '#fs',

        data: {
            fileList: [],
            newFolder: '',
            currFileName: '',
            haveFile: true,
            hideNew: true,
            loadFile: false,
            uploadSta: false,
            uploadFinish: false,
            uploadSuccess: true,
            deleteFile: false,
            deleteSta: false,
            deleteFinish: false,
            hide_errorPage: true,
            errorAction: '',
            errorMsg: '',
            tips: '',
            uploadPercent: '0',
            lang: {
                title_str: '',
                loading_str: '',
                emptyFolder_str: '',
                ssoFail_str: '',
                connectFail_str: '',
                deleteFail_str: '',
                deleteSucc_str: '',
                deleting_str: '',
                deleteFile_str: '',
                uploadFail_str: '',
                uploadSucc_str: '',
                uploading_str: '',
                newFolder_str: '',
                cancel_str: '',
                confirm_str: '',
                openDir_str: '',
                confirmDelFile: '',
            }
        },

        mounted: function () {
            this.$nextTick(function () {
                this.render();
                this.initGetFile();
            })
        },

        filters: {
            trim: function (str) {
                if (str.length > 35) {
                    return str.substr(0, 30) + '...';
                } else {
                    return str;
                }

            }
        },

        methods: {
            render: function () {
                this.lang.title_str = '文件系统';
                this.lang.loading_str = '加载中...';
                this.lang.emptyFolder_str = '这是一个空文件夹。';
                this.lang.ssoFail_str = 'SSO授权失败！';
                this.lang.getFileFail_str = '获取文件失败！';
                this.lang.connectFail_str = '连接服务器失败！';
                this.lang.deleteFail_str = '删除失败！';
                this.lang.deleteSucc_str = '删除成功！';
                this.lang.deleting_str = '正在删除...';
                this.lang.deleteFile_str = '删除文件';
                this.lang.uploadFail_str = '上传失败！';
                this.lang.uploadSucc_str = '上传成功！';
                this.lang.uploading_str = '正在上传';
                this.lang.newFolder_str = '新建文件夹';
                this.lang.cancel_str = '取消';
                this.lang.confirm_str = '确定';
                this.lang.openDir_str = '正在打开文件夹...';
                this.lang.confirmDelFile = '您确认删除文件！';
                this.tips = this.lang.loading_str;
            },
            initGetFile: function () {
                var _this = this;
                var hash = _this.getHash();
                var url = '/prx/000/http/' + fileProxy + '/api/v1/fileproxy/-/' + hash + '?json=1';
                axios.get(url).then(function (res) {
                    if (res.data.error == 0) {
                        _this.fileList = res.data.data;
                        _this.fileList.forEach(function(item, index) {
                        var css = _this.fileType(item.name);
                            _this.$set(item, 'fileType', css);
                        });

                        history.replaceState(_this.fileList, null);

                        if (!res.data.data.length) {
                            console.log('NO file');
                            _this.tips = _this.lang.emptyFolder_str;
                            _this.haveFile = false;
                        } else {
                            _this.tips = _this.lang.loading_str;
                            _this.haveFile = true;
                        }
                    } else {
                        var errnum = res.data.error;
                        _this.tips = _this.lang.ssoFail_str;
                    }
                }).catch(function (err) {
                    console.log(err);
                    _this.tips = _this.lang.connectFail_str;
                });
            },

            openDir: function (item) {
                var _this = this;
                _this.loadFile = true;
                var hash = _this.getHash();
                var url = '/prx/000/http/' + fileProxy + '/api/v1/fileproxy/-/' + hash + item.name + '/?json=1';

                axios.get(url).then(function (res) {
                    if (res.data.error == 0) {
                        _this.fileList = res.data.data;
                        _this.fileList.forEach(function(item, index) {
                        var css = _this.fileType(item.name);
                            _this.$set(item, 'fileType', css);
                        });

                        _this.loadFile = false;

                        var newUrl = window.location.href + item.name + '/';
                        history.pushState(_this.fileList, null, newUrl);

                        if (!res.data.data.length) {
                            console.log('NO file');
                            _this.tips = _this.lang.emptyFolder_str;
                            _this.haveFile = false;
                        } else {
                            _this.tips = _this.lang.loading_str;
                            _this.haveFile = true;
                        }
                    } else {
                        _this.tips = _this.lang.ssoFail_str;
                    }
                }).catch(function (err) {
                    console.log(err);
                    _this.tips = _this.lang.connectFail_str;
                });
                
            },

            openFile: function (item) {
                var _this = this;
                var hash = _this.getHash();
                var url = '/prx/000/http/' + fileProxy + '/api/v1/fileproxy/-/' + hash + item.name;
                window.open(url);
            },

            confirmDelete: function (item) {
                var _this = this;
                _this.deleteFile = true;
                _this.currFileName = item.name;
            },

            hideDelete: function () {
                this.deleteFile = false;
            },

            showErrorPage: function (title) {
                var _this = this;
                _this.hide_errorPage = false;
                _this.errorAction = title;
            },

            hideError: function () {
                this.hide_errorPage = true;
            },

            delFile: function () {
                var _this = this;
                _this.deleteFile = false;
                _this.deleteSta = true;
                var hash = _this.getHash();
                var url = '/prx/000/http/' + fileProxy + '/api/v1/fileproxy/-/' + hash + _this.currFileName;

                console.log(url);
                axios.delete(url).then(function (res) {
                    if (res.data.error == 0) {
                        console.log('delete success');
                        _this.deleteFinish = true;
                        _this.initGetFile();
                        setTimeout(function () {
                            _this.deleteSta = false;
                            _this.deleteFinish = false;
                        }, 300);
                    } else {
                        _this.deleteSta = false;
                        _this.deleteFinish = false;
                        var title = _this.lang.deleteFail_str;
                        _this.showErrorPage(title);
                    }
                }).catch(function () {
                        _this.deleteSta = false;
                        _this.deleteFinish = false;
                        var title = _this.lang.deleteFail_str;
                        _this.showErrorPage(title);
                })
            },

            chooseFile: function () {
                var fileObj = document.getElementsByName('uploadFile')[0];
                fileObj.click();
            },

            fileChange: function () {
                var _this = this;
                _this.uploadSta = true; // loading display
                var hash = _this.getHash();
                var url = '';
                var newName = '';
                var formData = new FormData();
                var fileObj = document.getElementsByName('uploadFile')[0].files[0];
                
                newName = _this.createFilename(_this.fileList, fileObj);
                url = '/prx/000/http/' + fileProxy + '/api/v1/fileproxy/-/' + hash + newName;
                console.log(newName);
                formData.append("file", fileObj);

                axios.post(url, formData, {
                    onUploadProgress: function (e) {
                        _this.uploadPercent = parseInt((e.loaded / e.total) * 100 - 1);
                    }
                }).then(function (res) {
                    _this.uploadFinish = true;
                    if (res.data.error == 0) { 
                        _this.initGetFile();
                        // close loading
                        setTimeout(function () {
                            _this.uploadSta = false;
                            _this.uploadFinish = false;
                        }, 300);
                    } else {
                        console.log('upload file error');
                        console.log(res.data.error + ' : ' + res.data.data);
                        _this.uploadSta = false;
                        _this.uploadFinish = false;
                        // call error page
                        var title = _this.lang.uploadFail_str;
                        _this.showErrorPage(title);
                    }
                }).catch(function () {
                    _this.uploadSta = false;
                    var title = _this.lang.uploadFail_str;
                    _this.showErrorPage(title);
                })
            },

            createFilename: function (fileList, fileObj) {
                var temp = '',
                    newName = '',
                    i, j;
                for(i = 0; i < fileList.length; i++) {
                    var item = fileList[i];
                    if(item.name === fileObj.name) {
                        temp = fileObj.name.split('.');
                        temp = temp[0] + '-' + (Math.random() * 100).toString().split('.')[0] + '.' + temp[1];
                        j = i;
                        for(j; j < fileList.length; j++) {
                            if(temp == fileList[i].name) {
                                this.createFilename(fileList, fileObj);
                            } 
                        }
                        newName = temp;
                        return newName;
                    }
                };
                if (!newName.length) {
                    newName = fileObj.name;
                    return newName;
                }
            },

            newDir: function () {
                var _this = this;
                var hash = _this.getHash();
                var url = '/prx/000/http/' + fileProxy + '/api/v1/fileproxy/-/' + hash + _this.newFolder + '/';
                axios.post(url).then(function () {
                    _this.hideNew = true;
                    _this.newFolder = '';
                    _this.initGetFile();
                }).catch(function () {
                    _this.hideNew = true;
                    _this.newFolder = '';
                })
            },

            displayFolder: function () {
                this.hideNew = false;
            },

            hideNewFolder: function () {
                this.hideNew = true;
            },

            getHash: function () {
                var hash = window.location.hash.substr(1);
                if (hash.substr(-1) != '/') {
                    hash += '/';
                }
                return hash;
            },

            fileType: function (str) {
                var type = str.toLowerCase().split('.').pop();
                var cssName = iconMap[type];
                if (typeof cssName == 'undefined') {
                    cssName = 'an-file-o';
                }
                return cssName;
            }

        }
    });

    window.onpopstate = function (e) {
        console.log('pop state');
        console.log('state', JSON.stringify(e.state));
        if (e.state != null) {
            app.fileList = e.state;
        } else {
            window.location.reload();
        }
    }

    
    
})(window);

