// v1.0.14

(function (exports) {
    exports.header = new Vue({
        el: '.header',
        data: {
            user: '',
            logout: '',
            change: ''
        },

        mounted: function () {
            this.$nextTick(function () {
                this.renderHeader();
            });
        },

        methods: {
            renderHeader: function () {
                this.user = _AN_user;
                this.logout = _AN_str_logout;
                this.change = _AN_str_changepass1;
            }
        }
    });

    exports.weblink = new Vue({
        el: '#weblinks',
        data: {
            weblinks: [],
            lang: {
                title_str: '',
                noweblinks_str: ''
            }
        },

        mounted: function () {
            this.$nextTick(function () {
                this.renderWeblink();
            });
        },

        methods: {
            renderWeblink: function () {
                this.weblinks = _AN_weblinks_list;
                this.lang.title_str = _AN_str_weblinks;
                this.lang.noweblinks_str = "No weblinks"
            }
        }
    });

    exports.bookmark = new Vue({
        el: '#bookmarks',
        data: {
            bookmarks: [],
            seen: true,
            hide_dialog: true,
            hide_modelPage: true,
            bookID: '',
            lang: {
                title_str: '',
                edit_str: '',
                delete_str: '',
                addBook_str: '',
                delBook_str: '',
                delInfo_str: '',
                cancel_str: '',
                actionErr_str: '',
                addBookFail_str: '',
                confirm: ''
            }
        },

        mounted: function () {
            this.$nextTick(function () {
                this.renderBookmark();
            });
        },

        methods: {
            getRdpIP: function () {
                var rdpIP = '';
                if (_AN_guacamole_url.length > 0) {
                    var res = _AN_guacamole_url.split('//');
                    res = res[1].split('/');
                    rdpIP = res[0];
                } else {
                    rdpIP = '10.8.11.21:8080';
                }    
                return rdpIP;
            },
            renderBookmark: function () {
                this.lang.title_str = _AN_str_bookmark_links;
                this.lang.edit_str = _AN_str_h5_edit;
                this.lang.delete_str = _AN_str_h5_delete;
                this.lang.addBook_str = _AN_str_add_bookmark;
                this.lang.delBook_str = _AN_str_h5_delete_bookmark;
                this.lang.delInfo_str =  _AN_str_h5_del_bookmark;
                this.lang.cancel_str = _AN_str_cancel;
                this.lang.actionErr_str = '操作失败';
                this.lang.addBookFail_str = '添加书签失败，最多添加100个书签';
                this.lang.confirm = '确定'
            

                if (typeof(_AN_bookmarks_list) === 'undefined') {
                    this.seen = false;
                } else {
                    var newArrayWeb = new Array();
                    var obj = {};
                    var len = _AN_bookmarks_list.length;
                    for (var i = 0; i < len; i++) {
                        if (!(_AN_bookmarks_list[i].href in obj)) {
                            if (_AN_bookmarks_list[i].type == 2) { // desktop
                                if (_AN_show_desktop) { // enable DD
                                    if (_AN_guacamole_url.length) { // configure rdpURL
                                        var RDP_serverIP = this.getRdpIP();
                                        var desktopAddr = '';
                                        if (_AN_bookmarks_list[i].url.indexOf(':') > -1) {
                                            var ip = _AN_bookmarks_list[i].url.split(':')[0];
                                            var port = _AN_bookmarks_list[i].url.split(':')[1];
                                            desktopAddr = ip + '&p=' + port;
                                        } else {
                                            desktopAddr = _AN_bookmarks_list[i].url + '&p=3389'; 
                                        }
                                        _AN_bookmarks_list[i].url = '/prx/000/http/' + RDP_serverIP + '/g/index.html?hs=' + desktopAddr +'&u=AG_USERNAME_FOR_RDP_PROXY_DESKTOP&s=AG_PASSWORD_FOR_RDP_PROXY_DESKTOP&dm=AG_RDDOMAIN_FOR_RDP_PROXY_DESKTOP';
                                        newArrayWeb.push(_AN_bookmarks_list[i]);
                                    }
                                }
                            } else if (_AN_bookmarks_list[i].type == 1) { // cifs
                                if (_AN_enable_fileshare) {
                                    _AN_bookmarks_list[i].url = '/prx/000/http/localh/cifs?path=/&service=' + _AN_bookmarks_list[i].url;
                                    // newArrayWeb.push(_AN_bookmarks_list[i]);
                                }
                            } else { // weblink
                                if (_AN_bookmarks_list[i].url.indexOf('fileproxy') > -1) { // file
                                    if (_AN_file_server_url.length) {
                                        var url = _AN_bookmarks_list[i].url.split('/api/v1/fileproxy/-/')[1];
                                        _AN_bookmarks_list[i].url = './fs.html#' + url;
                                        newArrayWeb.push(_AN_bookmarks_list[i]);
                                    }
                                } else {
                                    _AN_bookmarks_list[i].url = this.rewriteUrl(_AN_bookmarks_list[i].url);
                                    newArrayWeb.push(_AN_bookmarks_list[i]);
                                }
                            }
                        }
                        obj[_AN_bookmarks_list[i].url] = "";
                    }
                    this.bookmarks = newArrayWeb;
                }
            },
            rewriteUrl: function (url) {
                if (!_AN_enable_rewrite) return url;
                var final_url = "/prx/000/" + url;
                final_url = final_url.replace(/:./, "");
                return final_url;
            },

            openLink: function (item) {
                window.open(item.url);
            },
            deleteBook: function (item) {
                console.log('deleBook');
                this.$set(this, 'bookID', item.id);
                this.$set(this, 'hide_dialog', false);
            },
            editBook: function (item) {
                window.location.href = './edit_bookmark.html?id=' + item.id;
            },
            hide: function () {
                console.log('hide Dialog');
                this.$set(this, 'hide_dialog', true);
            },
            delBook: function () {
                var delBookmarkUrl = '/prx/000/http/localh:65200/motionpro/postlogin/bookmark?action=delete&id=' + this.bookID;
                var _this = this;
                axios.get(delBookmarkUrl).then(function () {
                    window.location.reload();
                }).catch(function () {
                    _this.$set(_this, 'hide_dialog', true);
                })

            },
            addBook: function () {
                if (_AN_bookmarks_list.length > 99) {
                    // tips
                    this.hide_modelPage = false;
                    // this.lang.addBookFile_str = '添加书签失败，最多添加100个书签'
                    
                } else {
                    window.location.href = './add_bookmark.html';
                }
            },
            hidePage: function () {
                this.hide_modelPage = true;
            }
        }

    })
})(window);
